/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.dto.marketdata;

import java.math.BigDecimal;
import java.util.Date;
import org.joda.money.BigMoney;

public final class Ticker {
    private final String tradableIdentifier;
    private final BigMoney last;
    private final BigMoney bid;
    private final BigMoney ask;
    private final BigMoney high;
    private final BigMoney low;
    private final BigDecimal volume;
    private final Date timestamp;

    private Ticker(String tradableIdentifier, BigMoney last, BigMoney bid, BigMoney ask, BigMoney high, BigMoney low, BigDecimal volume, Date timestamp) {
        this.tradableIdentifier = tradableIdentifier;
        this.last = last;
        this.bid = bid;
        this.ask = ask;
        this.high = high;
        this.low = low;
        this.volume = volume;
        this.timestamp = timestamp;
    }

    public String getTradableIdentifier() {
        return this.tradableIdentifier;
    }

    public BigMoney getLast() {
        return this.last;
    }

    public BigMoney getBid() {
        return this.bid;
    }

    public BigMoney getAsk() {
        return this.ask;
    }

    public BigMoney getHigh() {
        return this.high;
    }

    public BigMoney getLow() {
        return this.low;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "Ticker [tradableIdentifier=" + this.tradableIdentifier + ", last=" + this.last + ", bid=" + this.bid + ", ask=" + this.ask + ", high=" + this.high + ", low=" + this.low + ", volume=" + this.volume + ", timestamp=" + this.timestamp + "]";
    }

    public static class TickerBuilder {
        private String tradableIdentifier;
        private BigMoney last;
        private BigMoney bid;
        private BigMoney ask;
        private BigMoney high;
        private BigMoney low;
        private BigDecimal volume;
        private Date timestamp;
        private boolean isBuilt = false;

        public static TickerBuilder newInstance() {
            return new TickerBuilder();
        }

        public Ticker build() {
            this.validateState();
            Ticker ticker = new Ticker(this.tradableIdentifier, this.last, this.bid, this.ask, this.high, this.low, this.volume, this.timestamp);
            this.isBuilt = true;
            return ticker;
        }

        private void validateState() {
            if (this.isBuilt) {
                throw new IllegalStateException("The entity has been built");
            }
        }

        public TickerBuilder withTradableIdentifier(String tradableIdentifier) {
            this.tradableIdentifier = tradableIdentifier;
            return this;
        }

        public TickerBuilder withLast(BigMoney last) {
            this.last = last;
            return this;
        }

        public TickerBuilder withBid(BigMoney bid) {
            this.bid = bid;
            return this;
        }

        public TickerBuilder withAsk(BigMoney ask) {
            this.ask = ask;
            return this;
        }

        public TickerBuilder withHigh(BigMoney high) {
            this.high = high;
            return this;
        }

        public TickerBuilder withLow(BigMoney low) {
            this.low = low;
            return this;
        }

        public TickerBuilder withVolume(BigDecimal volume) {
            this.volume = volume;
            return this;
        }

        public TickerBuilder withTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }
    }
}

