/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.dto.marketdata;

import com.xeiam.xchange.dto.Order;
import java.math.BigDecimal;
import java.util.Date;
import org.joda.money.BigMoney;

public final class Trade
implements Comparable<Trade> {
    private final Order.OrderType type;
    private final BigDecimal tradableAmount;
    private final String tradableIdentifier;
    private final String transactionCurrency;
    private final BigMoney price;
    private final Date timestamp;
    private final long id;

    public Trade(Order.OrderType type, BigDecimal tradableAmount, String tradableIdentifier, String transactionCurrency, BigMoney price, Date timestamp, long id) {
        this.type = type;
        this.tradableAmount = tradableAmount;
        this.tradableIdentifier = tradableIdentifier;
        this.transactionCurrency = transactionCurrency;
        this.price = price;
        this.timestamp = timestamp;
        this.id = id;
    }

    public Order.OrderType getType() {
        return this.type;
    }

    public BigDecimal getTradableAmount() {
        return this.tradableAmount;
    }

    public String getTradableIdentifier() {
        return this.tradableIdentifier;
    }

    public String getTransactionCurrency() {
        return this.transactionCurrency;
    }

    public BigMoney getPrice() {
        return this.price;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return "Trade [type=" + (Object)((Object)this.type) + ", tradableAmount=" + this.tradableAmount + ", tradableIdentifier=" + this.tradableIdentifier + ", transactionCurrency=" + this.transactionCurrency + ", price=" + this.price + ", timestamp=" + this.timestamp + ", id=" + this.id + "]";
    }

    @Override
    public int compareTo(Trade trade) {
        return Long.valueOf(this.getId()).compareTo(trade.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id == ((Trade)o).id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

