/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.service.streaming;

import com.xeiam.xchange.service.streaming.DefaultExchangeEvent;
import com.xeiam.xchange.service.streaming.ExchangeEventListener;
import com.xeiam.xchange.service.streaming.ExchangeEventType;
import com.xeiam.xchange.service.streaming.JsonWrappedExchangeEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketEventProducer
extends WebSocketClient {
    private final Logger logger = LoggerFactory.getLogger(WebSocketEventProducer.class);
    private final ExchangeEventListener exchangeEventListener;

    public WebSocketEventProducer(String url, ExchangeEventListener exchangeEventListener, Map<String, String> headers) throws URISyntaxException {
        super(new URI(url), (Draft)new Draft_17(), headers, 0);
        this.exchangeEventListener = exchangeEventListener;
    }

    public void onOpen(ServerHandshake handshakedata) {
        this.logger.debug("opened connection");
        this.logger.debug("onOpen");
        JsonWrappedExchangeEvent exchangeEvent = new JsonWrappedExchangeEvent(ExchangeEventType.CONNECT, "connected");
        this.exchangeEventListener.handleEvent(exchangeEvent);
    }

    public void onMessage(String message) {
        this.logger.debug(message);
        DefaultExchangeEvent exchangeEvent = new DefaultExchangeEvent(ExchangeEventType.MESSAGE, message);
        this.exchangeEventListener.handleEvent(exchangeEvent);
    }

    public void onClose(int code, String reason, boolean remote) {
        this.logger.debug("Connection closed by " + (remote ? "remote peer" : "us"));
        this.logger.debug("reason= " + reason);
        this.logger.debug("onClose");
        JsonWrappedExchangeEvent exchangeEvent = new JsonWrappedExchangeEvent(ExchangeEventType.DISCONNECT, "disconnected");
        this.exchangeEventListener.handleEvent(exchangeEvent);
    }

    public void onError(Exception ex) {
        ex.printStackTrace();
        this.logger.error("onError: {}", (Object)ex.getMessage());
        JsonWrappedExchangeEvent exchangeEvent = new JsonWrappedExchangeEvent(ExchangeEventType.ERROR, ex.getMessage());
        this.exchangeEventListener.handleEvent(exchangeEvent);
    }
}

