/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcurex;

import com.xeiam.xchange.bitcurex.dto.marketdata.BitcurexTicker;
import com.xeiam.xchange.bitcurex.dto.marketdata.BitcurexTrade;
import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.money.BigMoney;

public final class BitcurexAdapters {
    private BitcurexAdapters() {
    }

    public static List<LimitOrder> adaptOrders(List<BigDecimal[]> bitcurexOrders, String currency, Order.OrderType orderType, String id) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BigDecimal[] bitcurexOrder : bitcurexOrders) {
            limitOrders.add(BitcurexAdapters.adaptOrder(bitcurexOrder[1], bitcurexOrder[0], currency, orderType, id));
        }
        return limitOrders;
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, String currency, Order.OrderType orderType, String id) {
        String tradableIdentifier = "BTC";
        BigMoney limitPrice = MoneyUtils.parse((String)(currency + " " + price));
        return new LimitOrder(orderType, amount, tradableIdentifier, currency, id, null, limitPrice);
    }

    public static Trade adaptTrade(BitcurexTrade bitcurexTrade, String currency, String tradableIdentifier) {
        BigDecimal amount = bitcurexTrade.getAmount();
        BigMoney price = MoneyUtils.parse((String)(currency + " " + bitcurexTrade.getPrice()));
        Date date = DateUtils.fromMillisUtc((long)(bitcurexTrade.getDate() * 1000L));
        return new Trade(null, amount, tradableIdentifier, currency, price, date, bitcurexTrade.getTid());
    }

    public static Trades adaptTrades(BitcurexTrade[] bitcurexTrades, String currency, String tradableIdentifier) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        for (BitcurexTrade bitcurexTrade : bitcurexTrades) {
            tradesList.add(BitcurexAdapters.adaptTrade(bitcurexTrade, currency, tradableIdentifier));
        }
        return new Trades(tradesList);
    }

    public static String getPriceString(BigMoney price) {
        return price.getAmount().stripTrailingZeros().toPlainString();
    }

    public static Ticker adaptTicker(BitcurexTicker bitcurexTicker, String currency, String tradableIdentifier) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + bitcurexTicker.getLast()));
        BigMoney high = MoneyUtils.parse((String)(currency + " " + bitcurexTicker.getHigh()));
        BigMoney low = MoneyUtils.parse((String)(currency + " " + bitcurexTicker.getLow()));
        BigMoney buy = MoneyUtils.parse((String)(currency + " " + bitcurexTicker.getBuy()));
        BigMoney sell = MoneyUtils.parse((String)(currency + " " + bitcurexTicker.getSell()));
        BigDecimal volume = bitcurexTicker.getVol();
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withHigh(high).withLow(low).withBid(buy).withAsk(sell).withVolume(volume).build();
    }
}

