/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v1.service.marketdata.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.mtgox.MtGoxUtils;
import com.xeiam.xchange.mtgox.v1.MtGoxAdapters;
import com.xeiam.xchange.mtgox.v1.MtGoxV1;
import com.xeiam.xchange.mtgox.v1.dto.marketdata.MtGoxDepth;
import com.xeiam.xchange.mtgox.v1.dto.marketdata.MtGoxTicker;
import com.xeiam.xchange.mtgox.v1.dto.marketdata.MtGoxTrade;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

@Deprecated
public class MtGoxPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final MtGoxV1 mtGoxV1;

    public MtGoxPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.mtGoxV1 = (MtGoxV1)RestProxyFactory.createProxy(MtGoxV1.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        MtGoxTicker mtGoxTicker = this.mtGoxV1.getTicker(tradableIdentifier, currency);
        return MtGoxAdapters.adaptTicker(mtGoxTicker);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OrderBook getOrderBook(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        MtGoxDepth mtgoxDepth = null;
        if (args.length > 0) {
            if (!(args[0] instanceof PollingMarketDataService.OrderBookType)) throw new IllegalArgumentException();
            mtgoxDepth = args[0] == PollingMarketDataService.OrderBookType.FULL ? this.mtGoxV1.getFullDepth(tradableIdentifier, currency) : this.mtGoxV1.getDepth(tradableIdentifier, currency);
        } else {
            mtgoxDepth = this.mtGoxV1.getDepth(tradableIdentifier, currency);
        }
        List<LimitOrder> asks = MtGoxAdapters.adaptOrders(mtgoxDepth.getAsks(), currency, "ask", "");
        List<LimitOrder> bids = MtGoxAdapters.adaptOrders(mtgoxDepth.getBids(), currency, "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) {
        this.verify(tradableIdentifier, currency);
        MtGoxTrade[] mtGoxTrades = null;
        if (args.length > 0) {
            Long sinceTimeStamp = (Long)args[0];
            mtGoxTrades = this.mtGoxV1.getTrades(tradableIdentifier, currency, "y", sinceTimeStamp);
        } else {
            mtGoxTrades = this.mtGoxV1.getTrades(tradableIdentifier, currency);
        }
        return MtGoxAdapters.adaptTrades(mtGoxTrades);
    }

    public ExchangeInfo getExchangeInfo() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)MtGoxUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return MtGoxUtils.CURRENCY_PAIRS;
    }
}

