/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v1.service.trade.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotYetImplementedForExchangeException;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.MarketOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.mtgox.MtGoxUtils;
import com.xeiam.xchange.mtgox.v1.MtGoxAdapters;
import com.xeiam.xchange.mtgox.v1.MtGoxV1;
import com.xeiam.xchange.mtgox.v1.dto.trade.MtGoxGenericResponse;
import com.xeiam.xchange.mtgox.v1.dto.trade.MtGoxOpenOrder;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingTradeService;
import com.xeiam.xchange.utils.Assert;
import java.math.BigDecimal;
import si.mazi.rescu.HmacPostBodyDigest;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

@Deprecated
public class MtGoxPollingTradeService
extends BasePollingExchangeService
implements PollingTradeService {
    private final ParamsDigest paramsDigest;
    private final MtGoxV1 mtGoxV1;

    public MtGoxPollingTradeService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.mtGoxV1 = (MtGoxV1)RestProxyFactory.createProxy(MtGoxV1.class, (String)exchangeSpecification.getSslUri());
        this.paramsDigest = HmacPostBodyDigest.createInstance((String)exchangeSpecification.getSecretKey());
    }

    public OpenOrders getOpenOrders() {
        MtGoxOpenOrder[] mtGoxOpenOrders = this.mtGoxV1.getOpenOrders(MtGoxUtils.urlEncode(this.exchangeSpecification.getApiKey()), this.paramsDigest, this.getNonce());
        return new OpenOrders(MtGoxAdapters.adaptOrders(mtGoxOpenOrders));
    }

    public String placeMarketOrder(MarketOrder marketOrder) {
        this.verify((Order)marketOrder);
        MtGoxGenericResponse mtGoxSuccess = this.mtGoxV1.placeOrder(this.exchangeSpecification.getApiKey(), this.paramsDigest, this.getNonce(), marketOrder.getTradableIdentifier(), marketOrder.getTransactionCurrency(), marketOrder.getType().equals((Object)Order.OrderType.BID) ? "bid" : "ask", marketOrder.getTradableAmount().multiply(new BigDecimal(100000000)), null);
        return mtGoxSuccess.getReturnString();
    }

    public String placeLimitOrder(LimitOrder limitOrder) {
        this.verify((Order)limitOrder);
        Assert.notNull((Object)limitOrder.getLimitPrice().getAmount(), (String)"getLimitPrice().getAmount() cannot be null");
        Assert.notNull((Object)limitOrder.getLimitPrice().getCurrencyUnit(), (String)"getLimitPrice().getCurrencyUnit() cannot be null");
        String tradableIdentifier = limitOrder.getTradableIdentifier();
        String currency = limitOrder.getLimitPrice().getCurrencyUnit().toString();
        String type = limitOrder.getType().equals((Object)Order.OrderType.BID) ? "bid" : "ask";
        BigDecimal amount = limitOrder.getTradableAmount().multiply(new BigDecimal(100000000));
        String price = MtGoxUtils.getPriceString(limitOrder.getLimitPrice());
        MtGoxGenericResponse mtGoxSuccess = this.mtGoxV1.placeOrder(this.exchangeSpecification.getApiKey(), this.paramsDigest, this.getNonce(), tradableIdentifier, currency, type, amount, price);
        return mtGoxSuccess.getReturnString();
    }

    public boolean cancelOrder(String orderId) {
        Assert.notNull((Object)orderId, (String)"orderId cannot be null");
        MtGoxGenericResponse mtGoxGenericResponse = this.mtGoxV1.cancelOrder(this.exchangeSpecification.getApiKey(), this.paramsDigest, this.getNonce(), orderId);
        return mtGoxGenericResponse.getResult().equals("success");
    }

    private void verify(Order order) {
        Assert.notNull((Object)order.getTradableIdentifier(), (String)"getTradableIdentifier() cannot be null");
        Assert.notNull((Object)order.getType(), (String)"getType() cannot be null");
        Assert.notNull((Object)order.getTradableAmount(), (String)"getAmount_int() cannot be null");
        Assert.isTrue((boolean)MtGoxUtils.isValidCurrencyPair(new CurrencyPair(order.getTradableIdentifier(), order.getTransactionCurrency())), (String)"currencyPair is not valid");
    }

    private long getNonce() {
        return System.currentTimeMillis();
    }

    public Trades getTradeHistory(Object ... arguments) {
        throw new NotYetImplementedForExchangeException();
    }
}

