/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v2.service.streaming;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.mtgox.v2.service.streaming.MtGoxExchangeEventListener;
import com.xeiam.xchange.mtgox.v2.service.streaming.MtGoxStreamingConfiguration;
import com.xeiam.xchange.service.streaming.BaseWebSocketExchangeService;
import com.xeiam.xchange.service.streaming.ExchangeEventListener;
import com.xeiam.xchange.service.streaming.ExchangeStreamingConfiguration;
import com.xeiam.xchange.service.streaming.StreamingExchangeService;
import java.net.URI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtGoxWebsocketService
extends BaseWebSocketExchangeService
implements StreamingExchangeService {
    private final Logger logger = LoggerFactory.getLogger(MtGoxWebsocketService.class);
    private final ExchangeEventListener exchangeEventListener;
    private final MtGoxStreamingConfiguration configuration;

    public MtGoxWebsocketService(ExchangeSpecification exchangeSpecification, MtGoxStreamingConfiguration configuration) {
        super(exchangeSpecification, (ExchangeStreamingConfiguration)configuration);
        this.configuration = configuration;
        this.exchangeEventListener = new MtGoxExchangeEventListener(this.consumerEventQueue);
    }

    public void connect() {
        String apiBase = null;
        apiBase = this.configuration.isEncryptedChannel() ? String.format("%s:%s/mtgox/", this.exchangeSpecification.getSslUriStreaming(), this.exchangeSpecification.getPort()) : String.format("%s:%s/mtgox/", this.exchangeSpecification.getPlainTextUriStreaming(), this.exchangeSpecification.getPort());
        String channel = this.configuration.getChannel();
        URI uri = null;
        uri = channel == null ? URI.create(apiBase) : URI.create(apiBase + "?Channel=" + channel);
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("Origin", String.format("%s:%s", this.exchangeSpecification.getHost(), this.exchangeSpecification.getPort()));
        this.logger.debug("Streaming URI='{}'", (Object)uri);
        this.internalConnect(uri, this.exchangeEventListener, headers);
    }
}

