/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcoinium;

import com.xeiam.xchange.bitcoinium.dto.marketdata.BitcoiniumOrderbook;
import com.xeiam.xchange.bitcoinium.dto.marketdata.BitcoiniumTicker;
import com.xeiam.xchange.bitcoinium.dto.marketdata.BitcoiniumTickerHistory;
import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.money.BigMoney;

public final class BitcoiniumAdapters {
    private BitcoiniumAdapters() {
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, String currency, String orderTypeString, String id) {
        Order.OrderType orderType = orderTypeString.equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        String tradableIdentifier = "BTC";
        BigMoney limitPrice = MoneyUtils.parse((String)(currency + " " + price));
        return new LimitOrder(orderType, amount, tradableIdentifier, currency, limitPrice);
    }

    public static List<LimitOrder> adaptOrders(BitcoiniumOrderbook bitcoiniumOrders, String currency, String orderType, String id) {
        ArrayList<BigDecimal> amountList;
        ArrayList<BigDecimal> priceList;
        int listSize = 0;
        if (orderType.equals("ask")) {
            priceList = bitcoiniumOrders.getAskPriceList();
            amountList = bitcoiniumOrders.getAskVolumeList();
        } else {
            priceList = bitcoiniumOrders.getBidPriceList();
            amountList = bitcoiniumOrders.getBidVolumeList();
        }
        listSize = priceList.size();
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (int i = 0; i < listSize; ++i) {
            limitOrders.add(BitcoiniumAdapters.adaptOrder(amountList.get(i), priceList.get(i), currency, orderType, id));
        }
        return limitOrders;
    }

    public static Trades adaptTrades(BitcoiniumTickerHistory bitcoiniumTrades, String currency, String tradableIdentifier) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        long baseTime = bitcoiniumTrades.getBaseTimestamp();
        for (int i = 0; bitcoiniumTrades.getPriceHistoryList().size() > i; ++i) {
            BigMoney price = MoneyUtils.parse((String)(currency + " " + bitcoiniumTrades.getPriceHistoryList().get(i)));
            long delta = bitcoiniumTrades.getTimeStampOffsets().get(i).longValue();
            Date date = DateUtils.fromMillisUtc((long)((baseTime += delta) * 1000L));
            tradesList.add(new Trade(null, null, tradableIdentifier, currency, price, date, 0L));
        }
        return new Trades(tradesList);
    }

    public static String getPriceString(BigMoney price) {
        return price.getAmount().stripTrailingZeros().toPlainString();
    }

    public static Ticker adaptTicker(BitcoiniumTicker bitcoiniumTicker, String currency, String tradableIdentifier) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + bitcoiniumTicker.getLast()));
        BigMoney high = MoneyUtils.parse((String)(currency + " " + bitcoiniumTicker.getHigh()));
        BigMoney low = MoneyUtils.parse((String)(currency + " " + bitcoiniumTicker.getLow()));
        BigMoney ask = MoneyUtils.parse((String)(currency + " " + bitcoiniumTicker.getAsk()));
        BigMoney bid = MoneyUtils.parse((String)(currency + " " + bitcoiniumTicker.getBid()));
        BigDecimal volume = bitcoiniumTicker.getVolume();
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withHigh(high).withLow(low).withVolume(volume).withAsk(ask).withBid(bid).build();
    }
}

