/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcoinium.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.bitcoinium.Bitcoinium;
import com.xeiam.xchange.bitcoinium.BitcoiniumAdapters;
import com.xeiam.xchange.bitcoinium.BitcoiniumUtils;
import com.xeiam.xchange.bitcoinium.dto.marketdata.BitcoiniumOrderbook;
import com.xeiam.xchange.bitcoinium.dto.marketdata.BitcoiniumTicker;
import com.xeiam.xchange.bitcoinium.dto.marketdata.BitcoiniumTickerHistory;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class BitcoiniumPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final Bitcoinium bitcoinium;

    public BitcoiniumPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.bitcoinium = (Bitcoinium)RestProxyFactory.createProxy(Bitcoinium.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        String[] currencyExchange = currency.split("_");
        BitcoiniumTicker bitcoiniumTicker = this.bitcoinium.getTicker(currencyExchange[0], tradableIdentifier, currencyExchange[1]);
        return BitcoiniumAdapters.adaptTicker(bitcoiniumTicker, currencyExchange[1], tradableIdentifier);
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) {
        throw new NotAvailableFromExchangeException();
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        String[] currencyExchange = currency.split("_");
        BitcoiniumOrderbook bitcoiniumDepth = this.bitcoinium.getFullDepth(currencyExchange[0], tradableIdentifier, currencyExchange[1], "20p");
        List<LimitOrder> asks = BitcoiniumAdapters.adaptOrders(bitcoiniumDepth, currencyExchange[1], "ask", "");
        List<LimitOrder> bids = BitcoiniumAdapters.adaptOrders(bitcoiniumDepth, currencyExchange[1], "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) {
        this.verify(tradableIdentifier, currency);
        String[] currencyExchange = currency.split("_");
        BitcoiniumTickerHistory bitcoiniumTrades = this.bitcoinium.getTrades(currencyExchange[0], tradableIdentifier, currencyExchange[1], "30d");
        return BitcoiniumAdapters.adaptTrades(bitcoiniumTrades, currencyExchange[1], tradableIdentifier);
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)BitcoiniumUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BitcoiniumUtils.CURRENCY_PAIRS;
    }
}

