/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.virtex.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import com.xeiam.xchange.virtex.VirtEx;
import com.xeiam.xchange.virtex.VirtExAdapters;
import com.xeiam.xchange.virtex.VirtExUtils;
import com.xeiam.xchange.virtex.dto.marketdata.VirtExDepth;
import com.xeiam.xchange.virtex.dto.marketdata.VirtExTicker;
import com.xeiam.xchange.virtex.dto.marketdata.VirtExTrade;
import java.io.IOException;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class VirtExPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final VirtEx virtEx;

    public VirtExPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.virtEx = (VirtEx)RestProxyFactory.createProxy(VirtEx.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        VirtExTicker virtExTicker = this.virtEx.getTicker(currency);
        return VirtExAdapters.adaptTicker(virtExTicker, currency, tradableIdentifier);
    }

    public OrderBook getOrderBook(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        VirtExDepth virtExDepth = this.virtEx.getFullDepth(currency);
        List<LimitOrder> asks = VirtExAdapters.adaptOrders(virtExDepth.getAsks(), currency, "ask", "");
        List<LimitOrder> bids = VirtExAdapters.adaptOrders(virtExDepth.getBids(), currency, "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        VirtExTrade[] virtExTrades = this.virtEx.getTrades(currency);
        return VirtExAdapters.adaptTrades(virtExTrades, currency, tradableIdentifier);
    }

    public ExchangeInfo getExchangeInfo() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    private void verify(String tradableIdentifier, String currency) throws IOException {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)VirtExUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return VirtExUtils.CURRENCY_PAIRS;
    }
}

