/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xeiam.xchange.bitstamp.util.BitstampTransactionTypeDeserializer;
import java.math.BigDecimal;

public final class BitstampUserTransaction {
    private final String datetime;
    private final long id;
    private final long order_id;
    private final TransactionType type;
    private final BigDecimal usd;
    private final BigDecimal btc;
    private final BigDecimal btc_usd;
    private final BigDecimal fee;

    public BitstampUserTransaction(@JsonProperty(value="datetime") String datetime, @JsonProperty(value="id") long id, @JsonProperty(value="order_id") long order_id, @JsonProperty(value="type") @JsonDeserialize(using=BitstampTransactionTypeDeserializer.class) TransactionType type, @JsonProperty(value="usd") BigDecimal usd, @JsonProperty(value="btc") BigDecimal btc, @JsonProperty(value="btc_usd") BigDecimal btc_usd, @JsonProperty(value="fee") BigDecimal fee) {
        this.datetime = datetime;
        this.id = id;
        this.order_id = order_id;
        this.type = type;
        this.usd = usd;
        this.btc = btc;
        this.btc_usd = btc_usd;
        this.fee = fee;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public long getId() {
        return this.id;
    }

    public long getOrderId() {
        return this.order_id;
    }

    public TransactionType getType() {
        return this.type;
    }

    public boolean isDeposit() {
        return this.type == TransactionType.deposit;
    }

    public boolean isWithdrawal() {
        return this.type == TransactionType.withdrawal;
    }

    public boolean isMarketTrade() {
        return this.type == TransactionType.trade;
    }

    public BigDecimal getUsd() {
        return this.usd;
    }

    public BigDecimal getBtc() {
        return this.btc;
    }

    public BigDecimal getPrice() {
        return this.btc_usd;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public String toString() {
        return String.format("UserTransaction{datetime=%s, id=%d, type=%s, usd=%s, btc=%s, fee=%s}", new Object[]{this.datetime, this.id, this.type, this.usd, this.btc, this.fee});
    }

    public static enum TransactionType {
        deposit,
        withdrawal,
        trade;

    }
}

