/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp.service;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.FormParam;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

public class BitstampDigest
implements ParamsDigest {
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private final Mac mac256;
    private final String clientId;
    private final String apiKey;

    private BitstampDigest(String secretKeyBase64, String clientId, String apiKey) throws IllegalArgumentException {
        this.clientId = clientId;
        this.apiKey = apiKey;
        try {
            this.mac256 = Mac.getInstance(HMAC_SHA_256);
            this.mac256.init(new SecretKeySpec(secretKeyBase64.getBytes(), HMAC_SHA_256));
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key for hmac initialization.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Illegal algorithm for post body digest. Check the implementation.");
        }
    }

    public static BitstampDigest createInstance(String secretKeyBase64, String clientId, String apiKey) throws IllegalArgumentException {
        return secretKeyBase64 == null ? null : new BitstampDigest(secretKeyBase64, clientId, apiKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        this.mac256.update(restInvocation.getParamValue(FormParam.class, "nonce").toString().getBytes());
        this.mac256.update(this.clientId.getBytes());
        this.mac256.update(this.apiKey.getBytes());
        return String.format("%064x", new BigInteger(1, this.mac256.doFinal())).toUpperCase();
    }
}

