/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.bitstamp.BitstampAdapters;
import com.xeiam.xchange.bitstamp.BitstampAuthenticated;
import com.xeiam.xchange.bitstamp.BitstampUtils;
import com.xeiam.xchange.bitstamp.dto.account.BitstampBalance;
import com.xeiam.xchange.bitstamp.service.BitstampDigest;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingAccountService;
import java.io.IOException;
import java.math.BigDecimal;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class BitstampPollingAccountService
extends BasePollingExchangeService
implements PollingAccountService {
    private BitstampAuthenticated bitstampAuthenticated;
    private ParamsDigest signatureCreator;

    public BitstampPollingAccountService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.bitstampAuthenticated = (BitstampAuthenticated)RestProxyFactory.createProxy(BitstampAuthenticated.class, (String)exchangeSpecification.getSslUri());
        this.signatureCreator = BitstampDigest.createInstance(exchangeSpecification.getSecretKey(), exchangeSpecification.getUserName(), exchangeSpecification.getApiKey());
    }

    public AccountInfo getAccountInfo() throws IOException {
        BitstampBalance bitstampBalance = this.bitstampAuthenticated.getBalance(this.exchangeSpecification.getApiKey(), this.signatureCreator, BitstampUtils.getNonce());
        if (bitstampBalance.getError() != null) {
            throw new ExchangeException("Error getting balance. " + bitstampBalance.getError());
        }
        return BitstampAdapters.adaptAccountInfo(bitstampBalance, this.exchangeSpecification.getUserName());
    }

    public String withdrawFunds(BigDecimal amount, String address) throws IOException {
        return this.bitstampAuthenticated.withdrawBitcoin(this.exchangeSpecification.getApiKey(), this.signatureCreator, BitstampUtils.getNonce(), amount, address).toString();
    }

    public String requestBitcoinDepositAddress(String ... arguments) throws IOException {
        return this.bitstampAuthenticated.getBitcoinDepositAddress(this.exchangeSpecification.getApiKey(), this.signatureCreator, BitstampUtils.getNonce());
    }
}

