/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcoincharts;

import com.xeiam.xchange.bitcoincharts.dto.charts.ChartData;
import com.xeiam.xchange.bitcoincharts.dto.marketdata.BitcoinChartsTicker;
import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.marketdata.Ticker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.joda.money.BigMoney;

public final class BitcoinChartsAdapters {
    private BitcoinChartsAdapters() {
    }

    public static Ticker adaptTicker(BitcoinChartsTicker[] bitcoinChartsTickers, String tradableIdentifier) {
        for (int i = 0; i < bitcoinChartsTickers.length; ++i) {
            if (!bitcoinChartsTickers[i].getSymbol().equals(tradableIdentifier)) continue;
            BigMoney last = bitcoinChartsTickers[i].getClose() != null ? MoneyUtils.parse((String)(bitcoinChartsTickers[i].getCurrency() + " " + bitcoinChartsTickers[i].getClose())) : null;
            BigMoney bid = bitcoinChartsTickers[i].getBid() != null ? MoneyUtils.parse((String)(bitcoinChartsTickers[i].getCurrency() + " " + bitcoinChartsTickers[i].getBid())) : null;
            BigMoney ask = bitcoinChartsTickers[i].getAsk() != null ? MoneyUtils.parse((String)(bitcoinChartsTickers[i].getCurrency() + " " + bitcoinChartsTickers[i].getAsk())) : null;
            BigMoney high = bitcoinChartsTickers[i].getHigh() != null ? MoneyUtils.parse((String)(bitcoinChartsTickers[i].getCurrency() + " " + bitcoinChartsTickers[i].getHigh())) : null;
            BigMoney low = bitcoinChartsTickers[i].getLow() != null ? MoneyUtils.parse((String)(bitcoinChartsTickers[i].getCurrency() + " " + bitcoinChartsTickers[i].getLow())) : null;
            BigDecimal volume = bitcoinChartsTickers[i].getVolume();
            Date timeStamp = new Date(bitcoinChartsTickers[i].getLatestTrade() * 1000L);
            return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withBid(bid).withAsk(ask).withHigh(high).withLow(low).withVolume(volume).withTimestamp(timeStamp).build();
        }
        return null;
    }

    public static ChartData[] adaptChartData(ArrayList<ArrayList> pRawData) {
        ChartData[] ret = new ChartData[pRawData.size()];
        for (int i = 0; i < pRawData.size(); ++i) {
            ChartData chartData;
            ArrayList cd = pRawData.get(i);
            ret[i] = chartData = new ChartData(cd);
        }
        return ret;
    }
}

