/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcoincharts.service.polling;

import com.xeiam.xchange.CachedDataSession;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.bitcoincharts.BitcoinCharts;
import com.xeiam.xchange.bitcoincharts.BitcoinChartsAdapters;
import com.xeiam.xchange.bitcoincharts.BitcoinChartsUtils;
import com.xeiam.xchange.bitcoincharts.dto.marketdata.BitcoinChartsTicker;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;

public class BitcoinChartsPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService,
CachedDataSession {
    private final Logger logger = LoggerFactory.getLogger(BitcoinChartsPollingMarketDataService.class);
    private final BitcoinCharts bitcoinCharts;
    private long tickerRequestTimeStamp = 0L;
    private BitcoinChartsTicker[] cachedBitcoinChartsTickers;

    public BitcoinChartsPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.bitcoinCharts = (BitcoinCharts)RestProxyFactory.createProxy(BitcoinCharts.class, (String)exchangeSpecification.getPlainTextUri());
    }

    public long getRefreshRate() {
        return 900000L;
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BitcoinChartsUtils.CURRENCY_PAIRS;
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        if (this.tickerRequestTimeStamp == 0L || System.currentTimeMillis() - this.tickerRequestTimeStamp >= this.getRefreshRate()) {
            this.logger.debug("requesting BitcoinCharts tickers");
            this.tickerRequestTimeStamp = System.currentTimeMillis();
            this.cachedBitcoinChartsTickers = this.bitcoinCharts.getMarketData();
        }
        return BitcoinChartsAdapters.adaptTicker(this.cachedBitcoinChartsTickers, tradableIdentifier);
    }

    public OrderBook getOrderBook(String tradableIdentifier, String currency, Object ... args) {
        throw new NotAvailableFromExchangeException();
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) {
        throw new NotAvailableFromExchangeException();
    }

    public ExchangeInfo getExchangeInfo() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.isTrue((boolean)currency.equals("BTC"), (String)"Base curreny must be BTC for this exchange");
        Assert.isTrue((boolean)BitcoinChartsUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }
}

