/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.campbx.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.campbx.CampBXAdapters;
import com.xeiam.xchange.campbx.dto.marketdata.CampBXOrderBook;
import com.xeiam.xchange.campbx.dto.marketdata.CampBXTicker;
import com.xeiam.xchange.campbx.service.polling.CampBXPollingMarketDataService;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import java.io.IOException;
import java.util.List;

public class CampBXGenericPollingMarketDataService
extends CampBXPollingMarketDataService
implements PollingMarketDataService {
    public CampBXGenericPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        CampBXTicker campbxTicker = this.getCampBXTicker(tradableIdentifier, currency);
        return CampBXAdapters.adaptTicker(campbxTicker, currency, tradableIdentifier);
    }

    public OrderBook getOrderBook(String tradableIdentifier, String currency, Object ... args) throws IOException {
        CampBXOrderBook campBXOrderBook = this.getCampBXOrderBook(tradableIdentifier, currency);
        return CampBXAdapters.adaptOrders(campBXOrderBook, currency, tradableIdentifier);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public ExchangeInfo getExchangeInfo() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return this.getCampBXExchangeSymbols();
    }
}

