/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.campbx.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.campbx.CampBX;
import com.xeiam.xchange.campbx.CampBXUtils;
import com.xeiam.xchange.campbx.dto.marketdata.CampBXOrderBook;
import com.xeiam.xchange.campbx.dto.marketdata.CampBXTicker;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;

public class CampBXPollingMarketDataService
extends BasePollingExchangeService {
    private final Logger logger = LoggerFactory.getLogger(CampBXPollingMarketDataService.class);
    private final CampBX campBX;

    public CampBXPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.campBX = (CampBX)RestProxyFactory.createProxy(CampBX.class, (String)exchangeSpecification.getSslUri());
    }

    public CampBXTicker getCampBXTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        CampBXTicker campbxTicker = this.campBX.getTicker();
        if (!campbxTicker.isError()) {
            return campbxTicker;
        }
        throw new ExchangeException("Error calling getCampBXTicker(): " + campbxTicker.getError());
    }

    public CampBXOrderBook getCampBXOrderBook(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        CampBXOrderBook campBXOrderBook = this.campBX.getOrderBook();
        if (!campBXOrderBook.isError()) {
            return campBXOrderBook;
        }
        throw new ExchangeException("Error calling getCampBXFullOrderBook(): " + campBXOrderBook.getError());
    }

    public Trades getCampBXTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public ExchangeInfo getCampBXExchangeInfo() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)CampBXUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getCampBXExchangeSymbols() {
        return CampBXUtils.CURRENCY_PAIRS;
    }
}

