package uk.me.jstott.jcoord.ellipsoid;

/**
 * <p>
 * This class is part of the Jcoord package. Visit the <a
 * href="http://www.jstott.me.uk/jcoord/">Jcoord</a> website for more
 * information.
 * </p>
 * 
 * <p>
 * Class defining the Modified Airy reference ellipsoid.
 * </p>
 * 
 * <p>
 * (c) 2006 Jonathan Stott
 * </p>
 * 
 * <p>
 * Created on 02-Apr-2006
 * </p>
 * 
 * @author Jonathan Stott
 * @version 1.1
 * @since 1.1
 */
public class ModifiedAiryEllipsoid extends Ellipsoid {
  
  /**
   * Static reference of this ellipsoid.
   */
  private static ModifiedAiryEllipsoid ref = null;
  

  /**
   * Create an object defining the Modified Airy reference ellipsoid.
   * 
   * @since 1.1
   */
  private ModifiedAiryEllipsoid() {
    super(6377340.189, Double.NaN, 0.00667054015);
  }
  
  
  /**
   * Get the static instance of this ellipsoid
   * 
   * @return a reference to the static instance of this ellipsoid
   * @since 1.1
   */
  public static ModifiedAiryEllipsoid getInstance() {
    if (ref == null) {
      ref = new ModifiedAiryEllipsoid();
    }
    return ref;
  }
}