/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.SimulatorSystem;
import com.licel.jcardsim.io.JavaCardInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import javacard.framework.AID;
import javacard.framework.Applet;
import javacard.framework.JCSystem;
import javacard.framework.SystemException;
import org.bouncycastle.util.encoders.Hex;

public class Simulator
implements JavaCardInterface {
    static final String DEFAULT_ATR = "3BFA1800008131FE454A434F5033315632333298";
    static final String ATR_SYSTEM_PROPERTY = "com.licel.jcardsim.card.ATR";
    byte[] atr = null;
    static final String PROPERTY_PREFIX = "com.licel.jcardsim.card.applet.";
    static final String OLD_PROPERTY_PREFIX = "com.licel.jcardsim.smartcardio.applet.";
    static final MessageFormat AID_SP_TEMPLATE = new MessageFormat("{0}.AID");
    static final MessageFormat APPLET_CLASS_SP_TEMPLATE = new MessageFormat("{0}.Class");
    AppletClassLoader cl = new AppletClassLoader(new URL[0]);

    public Simulator() {
        this.resetRuntime();
        JCSystem.getVersion();
        this.atr = Hex.decode(System.getProperty(ATR_SYSTEM_PROPERTY, DEFAULT_ATR));
        for (int i = 0; i < 10; ++i) {
            byte[] aidBytes;
            String appletClassName;
            String selectedPrefix = PROPERTY_PREFIX;
            String aidPropertyName = PROPERTY_PREFIX + AID_SP_TEMPLATE.format(new Object[]{new Integer(i)});
            String aidPropertyOldName = OLD_PROPERTY_PREFIX + AID_SP_TEMPLATE.format(new Object[]{new Integer(i)});
            String appletAID = System.getProperty(aidPropertyName);
            if (appletAID == null && (appletAID = System.getProperty(aidPropertyOldName)) != null) {
                selectedPrefix = OLD_PROPERTY_PREFIX;
            }
            if (appletAID == null || (appletClassName = System.getProperty(selectedPrefix + APPLET_CLASS_SP_TEMPLATE.format(new Object[]{new Integer(i)}))) == null || (aidBytes = Hex.decode(appletAID)) == null || aidBytes.length < 5 || aidBytes.length > 16) continue;
            this.loadApplet(new AID(aidBytes, 0, (byte)aidBytes.length), appletClassName);
        }
    }

    public AID loadApplet(AID aid, String appletClassName, byte[] appletJarContents) throws SystemException {
        byte[] aidData = new byte[16];
        aid.getBytes(aidData, (short)0);
        Class<?> appletClass = null;
        try {
            this.cl.addAppletContents(appletJarContents);
            appletClass = this.cl.loadClass(appletClassName);
        }
        catch (Exception e) {
            SystemException.throwIt((short)1);
        }
        if (appletClass != null) {
            return this.loadApplet(aid, appletClass);
        }
        SystemException.throwIt((short)1);
        return null;
    }

    public AID loadApplet(AID aid, String appletClassName) throws SystemException {
        Class<?> appletClass = null;
        try {
            appletClass = this.cl.loadClass(appletClassName);
        }
        catch (ClassNotFoundException ex) {
            SystemException.throwIt((short)1);
        }
        if (this.checkAppletSuperclass(appletClass)) {
            return this.loadApplet(aid, appletClass);
        }
        SystemException.throwIt((short)1);
        return null;
    }

    public AID loadApplet(AID aid, Class appletClass) throws SystemException {
        if (!this.checkAppletSuperclass(appletClass)) {
            SystemException.throwIt((short)1);
        }
        SimulatorSystem.getRuntime().loadApplet(aid, appletClass);
        return aid;
    }

    public AID createApplet(AID aid, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        try {
            Class appletClass = SimulatorSystem.getRuntime().getAppletClass(aid);
            if (appletClass == null) {
                SystemException.throwIt((short)4);
            }
            SimulatorSystem.getRuntime().appletInstalling(aid);
            Method initMethod = appletClass.getMethod("install", byte[].class, Short.TYPE, Byte.TYPE);
            initMethod.invoke(null, bArray, new Short(bOffset), new Byte(bLength));
        }
        catch (Exception ex) {
            SystemException.throwIt((short)25668);
        }
        return aid;
    }

    public AID installApplet(AID aid, Class appletClass) throws SystemException {
        return this.installApplet(aid, appletClass, new byte[0], (short)0, (byte)0);
    }

    public AID installApplet(AID aid, Class appletClass, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        this.loadApplet(aid, appletClass);
        return this.createApplet(aid, bArray, bOffset, bLength);
    }

    public AID installApplet(AID aid, String appletClassName, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        this.loadApplet(aid, appletClassName);
        return this.createApplet(aid, bArray, bOffset, bLength);
    }

    public AID installApplet(AID aid, String appletClassName, byte[] appletContents, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        this.loadApplet(aid, appletClassName, appletContents);
        return this.createApplet(aid, bArray, bOffset, bLength);
    }

    public boolean selectApplet(AID aid) throws SystemException {
        int len;
        byte[] resp = SimulatorSystem.selectAppletWithResult(aid);
        return resp != null && resp.length > 1 && resp[(len = resp.length) - 2] == -112 && resp[len - 1] == 0;
    }

    public byte[] selectAppletWithResult(AID aid) throws SystemException {
        return SimulatorSystem.selectAppletWithResult(aid);
    }

    public byte[] transmitCommand(byte[] command) throws SystemException {
        return SimulatorSystem.transmitCommand(command);
    }

    public void reset() {
        SimulatorSystem.getRuntime().reset();
    }

    public final void resetRuntime() {
        SimulatorSystem.getRuntime().resetRuntime();
    }

    public byte[] getATR() {
        return this.atr;
    }

    private boolean checkAppletSuperclass(Class appletClass) {
        for (Class parent = appletClass; parent != Object.class; parent = parent.getSuperclass()) {
            if (parent != Applet.class) continue;
            return true;
        }
        return false;
    }

    class AppletClassLoader
    extends URLClassLoader {
        AppletClassLoader(URL[] urls) {
            super(urls, Simulator.class.getClassLoader());
        }

        void addAppletContents(byte[] appletJarContents) throws IOException {
            File downloadedAppletJar = File.createTempFile("applet", "contents");
            downloadedAppletJar.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(downloadedAppletJar);
            fos.write(appletJarContents);
            fos.close();
            this.addURL(downloadedAppletJar.toURI().toURL());
        }
    }
}

