/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import java.math.BigInteger;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;

public final class ByteContainer {
    private byte[] data;
    private boolean isInitialized;
    private byte memoryType;

    public ByteContainer() {
        this(0);
    }

    public ByteContainer(byte memoryType) {
        this.isInitialized = false;
        this.memoryType = memoryType;
    }

    public ByteContainer(BigInteger bInteger) {
        this(bInteger.toByteArray(), 0, (short)bInteger.toByteArray().length);
    }

    public ByteContainer(byte[] buff, short offset, short length) {
        this.setBytes(buff, offset, length);
    }

    public void setBigInteger(BigInteger bInteger) {
        this.setBytes(bInteger.toByteArray());
    }

    public void setBytes(byte[] buff) {
        this.setBytes(buff, (short)0, (short)buff.length);
    }

    public void setBytes(byte[] buff, short offset, short length) {
        if (this.data == null) {
            switch (this.memoryType) {
                case 2: {
                    this.data = JCSystem.makeTransientByteArray(length, (byte)2);
                    break;
                }
                case 1: {
                    this.data = JCSystem.makeTransientByteArray(length, (byte)2);
                    break;
                }
                default: {
                    this.data = new byte[length];
                }
            }
        }
        Util.arrayCopy(buff, offset, this.data, (short)0, length);
        this.isInitialized = true;
    }

    public BigInteger getBigInteger() {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)2);
        }
        return new BigInteger(1, this.data);
    }

    public byte[] getBytes(byte event) {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)2);
        }
        byte[] result = JCSystem.makeTransientByteArray((short)this.data.length, event);
        this.getBytes(result, (short)0);
        return result;
    }

    public short getBytes(byte[] dest, short offset) {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)2);
        }
        if (dest.length - offset < this.data.length) {
            CryptoException.throwIt((short)1);
        }
        Util.arrayCopy(this.data, (short)0, dest, offset, (short)this.data.length);
        return (short)this.data.length;
    }

    public void clear() {
        if (this.data != null) {
            Util.arrayFillNonAtomic(this.data, (short)0, (short)this.data.length, (byte)0);
        }
        this.isInitialized = false;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

