/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.KeyImpl;
import java.math.BigInteger;
import java.security.SecureRandom;
import javacard.security.CryptoException;
import javacard.security.ECKey;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.math.ec.ECCurve;

public abstract class ECKeyImpl
extends KeyImpl
implements ECKey {
    protected ByteContainer a = new ByteContainer();
    protected ByteContainer b = new ByteContainer();
    protected ByteContainer g = new ByteContainer();
    protected ByteContainer r = new ByteContainer();
    protected ByteContainer fp = new ByteContainer();
    protected short k;
    protected short e1;
    protected short e2;
    protected short e3;
    protected boolean isKInitialized;

    public ECKeyImpl(byte keyType, short keySize) {
        this.size = keySize;
        this.type = keyType;
        this.setDomainParameters(ECKeyImpl.getDefaultsDomainParameters(this.type, this.size));
    }

    public ECKeyImpl(ECKeyParameters parameters) {
        boolean isPrivate = parameters.isPrivate();
        boolean isF2M = parameters.getParameters().getCurve() instanceof ECCurve.F2m;
        this.type = (byte)(isPrivate ? (isF2M ? 10 : 12) : (isF2M ? 9 : 11));
        this.size = (short)parameters.getParameters().getCurve().getFieldSize();
        this.setDomainParameters(parameters.getParameters());
    }

    public void clearKey() {
        this.a.clear();
        this.b.clear();
        this.g.clear();
        this.r.clear();
        this.fp.clear();
        this.k = 0;
        this.e1 = 0;
        this.e2 = 0;
        this.e3 = 0;
    }

    protected boolean isDomainParametersInitialized() {
        return this.a.isInitialized() && this.b.isInitialized() && this.g.isInitialized() && this.r.isInitialized() && this.isKInitialized && (this.fp.isInitialized() || this.k != 0);
    }

    public void setFieldFP(byte[] buffer, short offset, short length) throws CryptoException {
        this.fp.setBytes(buffer, offset, length);
    }

    public void setFieldF2M(short e) throws CryptoException {
        this.setFieldF2M(e, (short)0, (short)0);
    }

    public void setFieldF2M(short e1, short e2, short e3) throws CryptoException {
        this.e1 = e1;
        this.e2 = e2;
        this.e3 = e3;
    }

    public void setA(byte[] buffer, short offset, short length) throws CryptoException {
        this.a.setBytes(buffer, offset, length);
    }

    public void setB(byte[] buffer, short offset, short length) throws CryptoException {
        this.b.setBytes(buffer, offset, length);
    }

    public void setG(byte[] buffer, short offset, short length) throws CryptoException {
        this.g.setBytes(buffer, offset, length);
    }

    public void setR(byte[] buffer, short offset, short length) throws CryptoException {
        this.r.setBytes(buffer, offset, length);
    }

    public void setK(short K) {
        this.k = K;
        this.isKInitialized = true;
    }

    public short getField(byte[] buffer, short offset) throws CryptoException {
        return this.fp.getBytes(buffer, offset);
    }

    public short getA(byte[] buffer, short offset) throws CryptoException {
        return this.a.getBytes(buffer, offset);
    }

    public short getB(byte[] buffer, short offset) throws CryptoException {
        return this.b.getBytes(buffer, offset);
    }

    public short getG(byte[] buffer, short offset) throws CryptoException {
        return this.g.getBytes(buffer, offset);
    }

    public short getR(byte[] buffer, short offset) throws CryptoException {
        return this.r.getBytes(buffer, offset);
    }

    public short getK() throws CryptoException {
        if (!this.isKInitialized) {
            CryptoException.throwIt((short)2);
        }
        return this.k;
    }

    public ECDomainParameters getDomainParameters() {
        if (!this.isDomainParametersInitialized()) {
            CryptoException.throwIt((short)2);
        }
        ECCurve curve = null;
        curve = this.fp.isInitialized() ? new ECCurve.Fp(this.fp.getBigInteger(), this.a.getBigInteger(), this.b.getBigInteger()) : new ECCurve.F2m(this.size, this.e1, this.e2, this.e3, this.a.getBigInteger(), this.b.getBigInteger(), this.r.getBigInteger(), BigInteger.valueOf(this.k));
        return new ECDomainParameters(curve, ((ECCurve)curve).decodePoint(this.g.getBytes((byte)1)), this.r.getBigInteger(), BigInteger.valueOf(this.k));
    }

    final void setDomainParameters(ECDomainParameters parameters) {
        this.a.setBigInteger(parameters.getCurve().getA().toBigInteger());
        this.b.setBigInteger(parameters.getCurve().getB().toBigInteger());
        this.g.setBytes(parameters.getG().getEncoded());
        this.r.setBigInteger(parameters.getN());
        this.setK(parameters.getH().shortValue());
        if (parameters.getCurve() instanceof ECCurve.Fp) {
            ECCurve.Fp ecfp = (ECCurve.Fp)parameters.getCurve();
            this.fp.setBigInteger(ecfp.getQ());
        } else {
            ECCurve.F2m ecf2m = (ECCurve.F2m)parameters.getCurve();
            this.setFieldF2M((short)ecf2m.getK1(), (short)ecf2m.getK2(), (short)ecf2m.getK3());
        }
    }

    public KeyGenerationParameters getKeyGenerationParameters(SecureRandom rnd) {
        if (this.isDomainParametersInitialized()) {
            return new ECKeyGenerationParameters(this.getDomainParameters(), rnd);
        }
        return new ECKeyGenerationParameters(ECKeyImpl.getDefaultsDomainParameters(this.type, this.size), rnd);
    }

    static KeyGenerationParameters getDefaultKeyGenerationParameters(byte algorithm, short keySize, SecureRandom rnd) {
        byte keyType = algorithm == 5 ? (byte)11 : 9;
        return new ECKeyGenerationParameters(ECKeyImpl.getDefaultsDomainParameters(keyType, keySize), rnd);
    }

    static ECDomainParameters getDefaultsDomainParameters(byte keyType, short keySize) {
        String curveName = "";
        switch (keySize) {
            case 113: 
            case 131: 
            case 163: 
            case 193: {
                if (keyType != 10 & keyType != 9) {
                    CryptoException.throwIt((short)1);
                }
                curveName = "sect" + keySize + "r1";
                break;
            }
            case 112: 
            case 128: 
            case 160: 
            case 192: {
                if (keyType != 12 & keyType != 11) {
                    CryptoException.throwIt((short)1);
                }
                curveName = "secp" + keySize + "r1";
                break;
            }
            default: {
                CryptoException.throwIt((short)1);
            }
        }
        X9ECParameters x9params = SECNamedCurves.getByName(curveName);
        return new ECDomainParameters(x9params.getCurve(), x9params.getG(), x9params.getN(), x9params.getH(), x9params.getSeed());
    }
}

