/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.ECKeyImpl;
import javacard.security.CryptoException;
import javacard.security.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class ECPublicKeyImpl
extends ECKeyImpl
implements ECPublicKey {
    protected ByteContainer w = new ByteContainer();

    public ECPublicKeyImpl(byte keyType, short keySize) {
        super(keyType, keySize);
    }

    public ECPublicKeyImpl(ECPublicKeyParameters params) {
        super(params);
        this.w.setBytes(params.getQ().getEncoded());
    }

    public void setW(byte[] buffer, short offset, short length) throws CryptoException {
        this.w.setBytes(buffer, offset, length);
    }

    public short getW(byte[] buffer, short offset) throws CryptoException {
        return this.w.getBytes(buffer, offset);
    }

    public boolean isInitialized() {
        return this.isDomainParametersInitialized() && this.w.isInitialized();
    }

    public void clearKey() {
        super.clearKey();
        this.w.clear();
    }

    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        ECDomainParameters dp = this.getDomainParameters();
        return new ECPublicKeyParameters(dp.getCurve().decodePoint(this.w.getBytes((byte)1)), dp);
    }
}

