/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ECPrivateKeyImpl;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.KeyAgreement;
import javacard.security.PrivateKey;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class KeyAgreementImpl
extends KeyAgreement {
    BasicAgreement engine;
    byte algorithm;
    ECPrivateKeyImpl privateKey;

    public KeyAgreementImpl(byte algorithm) {
        this.algorithm = algorithm;
        switch (algorithm) {
            case 1: {
                this.engine = new ECDHBasicAgreement();
                break;
            }
            case 2: {
                this.engine = new ECDHCBasicAgreement();
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
    }

    public void init(PrivateKey privateKey) throws CryptoException {
        if (privateKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!(privateKey instanceof ECPrivateKeyImpl)) {
            CryptoException.throwIt((short)1);
        }
        this.engine.init(((ECPrivateKeyImpl)privateKey).getParameters());
        this.privateKey = (ECPrivateKeyImpl)privateKey;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public short generateSecret(byte[] publicData, short publicOffset, short publicLength, byte[] secret, short secretOffset) throws CryptoException {
        byte[] publicKey = JCSystem.makeTransientByteArray(publicLength, (byte)1);
        Util.arrayCopyNonAtomic(publicData, publicOffset, publicKey, (short)0, publicLength);
        ECPublicKeyParameters ecp = new ECPublicKeyParameters(((ECPrivateKeyParameters)this.privateKey.getParameters()).getParameters().getCurve().decodePoint(publicKey), ((ECPrivateKeyParameters)this.privateKey.getParameters()).getParameters());
        byte[] result = this.engine.calculateAgreement(ecp).toByteArray();
        if (result.length > secret.length - secretOffset) {
            CryptoException.throwIt((short)1);
        }
        Util.arrayCopyNonAtomic(result, (short)0, secret, secretOffset, (short)result.length);
        return (short)result.length;
    }
}

