/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.DSAKeyImpl;
import com.licel.jcardsim.crypto.DSAPrivateKeyImpl;
import com.licel.jcardsim.crypto.DSAPublicKeyImpl;
import com.licel.jcardsim.crypto.ECKeyImpl;
import com.licel.jcardsim.crypto.ECPrivateKeyImpl;
import com.licel.jcardsim.crypto.ECPublicKeyImpl;
import com.licel.jcardsim.crypto.KeyImpl;
import com.licel.jcardsim.crypto.KeyWithParameters;
import com.licel.jcardsim.crypto.RSAKeyImpl;
import com.licel.jcardsim.crypto.RSAPrivateCrtKeyImpl;
import java.security.SecureRandom;
import javacard.security.CryptoException;
import javacard.security.PrivateKey;
import javacard.security.PublicKey;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public final class KeyPairImpl {
    byte algorithm;
    short keyLength;
    AsymmetricCipherKeyPairGenerator engine;
    PrivateKey privateKey;
    PublicKey publicKey;
    SecureRandom rnd = new SecureRandom();
    KeyGenerationParameters keyGenerationParameters;

    public final void genKeyPair() throws CryptoException {
        this.initEngine();
        AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
        if (kp.getPublic() instanceof RSAKeyParameters) {
            this.publicKey = new RSAKeyImpl((RSAKeyParameters)kp.getPublic());
            if (kp.getPrivate() instanceof RSAPrivateCrtKeyParameters) {
                this.privateKey = new RSAPrivateCrtKeyImpl((RSAPrivateCrtKeyParameters)kp.getPrivate());
            } else if (kp.getPrivate() instanceof RSAKeyParameters) {
                this.privateKey = new RSAKeyImpl((RSAKeyParameters)kp.getPrivate());
            }
        } else if (kp.getPublic() instanceof DSAPublicKeyParameters) {
            this.publicKey = new DSAPublicKeyImpl((DSAPublicKeyParameters)kp.getPublic());
            this.privateKey = new DSAPrivateKeyImpl((DSAPrivateKeyParameters)kp.getPrivate());
        } else if (kp.getPublic() instanceof ECPublicKeyParameters) {
            this.publicKey = new ECPublicKeyImpl((ECPublicKeyParameters)kp.getPublic());
            this.privateKey = new ECPrivateKeyImpl((ECPrivateKeyParameters)kp.getPrivate());
        } else {
            CryptoException.throwIt((short)5);
        }
    }

    public KeyPairImpl(byte algorithm, short keyLength) throws CryptoException {
        this.algorithm = algorithm;
        this.keyLength = keyLength;
    }

    public KeyPairImpl(PublicKey publicKey, PrivateKey privateKey) throws CryptoException {
        if (publicKey == null && privateKey == null) {
            CryptoException.throwIt((short)1);
        }
        if (publicKey != null && !(publicKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        this.publicKey = publicKey;
        if (this.publicKey != null) {
            this.selectAlgorithmByType(this.publicKey.getType());
        }
        if (privateKey != null && !(privateKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        this.privateKey = privateKey;
        if (this.privateKey != null) {
            this.selectAlgorithmByType(this.privateKey.getType());
        }
    }

    public PublicKey getPublic() {
        return this.publicKey;
    }

    public PrivateKey getPrivate() {
        return this.privateKey;
    }

    private void selectAlgorithmByType(byte keyType) {
        switch (keyType) {
            case 4: 
            case 5: {
                this.algorithm = 1;
                break;
            }
            case 6: {
                this.algorithm = (byte)2;
                break;
            }
            case 9: 
            case 10: {
                this.algorithm = (byte)4;
                break;
            }
            case 11: 
            case 12: {
                this.algorithm = (byte)5;
                break;
            }
            case 7: 
            case 8: {
                this.algorithm = (byte)3;
            }
        }
    }

    private void initEngine() {
        if (this.publicKey != null || this.privateKey != null) {
            this.keyGenerationParameters = ((KeyImpl)(this.privateKey == null ? this.publicKey : this.privateKey)).getKeyGenerationParameters(this.rnd);
        }
        switch (this.algorithm) {
            case 1: 
            case 2: {
                if (this.keyGenerationParameters == null) {
                    this.keyGenerationParameters = RSAKeyImpl.getDefaultKeyGenerationParameters(this.keyLength, this.rnd);
                }
                this.engine = new RSAKeyPairGenerator();
                break;
            }
            case 3: {
                if (this.keyLength < 512 || this.keyLength > 1024 || this.keyLength % 64 != 0) {
                    CryptoException.throwIt((short)1);
                }
                if (this.keyGenerationParameters == null) {
                    this.keyGenerationParameters = DSAKeyImpl.getDefaultKeyGenerationParameters(this.keyLength, this.rnd);
                }
                this.engine = new DSAKeyPairGenerator();
                break;
            }
            case 4: 
            case 5: {
                if (this.keyGenerationParameters == null) {
                    this.keyGenerationParameters = ECKeyImpl.getDefaultKeyGenerationParameters(this.algorithm, this.keyLength, this.rnd);
                }
                this.engine = new ECKeyPairGenerator();
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        this.engine.init(this.keyGenerationParameters);
    }
}

