/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import javacard.security.CryptoException;
import javacard.security.MessageDigest;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class MessageDigestImpl
extends MessageDigest {
    private Digest engine;
    private byte algorithm;

    public MessageDigestImpl(byte algorithm) {
        this.algorithm = algorithm;
        switch (algorithm) {
            case 1: {
                this.engine = new SHA1Digest();
                break;
            }
            case 2: {
                this.engine = new MD5Digest();
                break;
            }
            case 3: {
                this.engine = new RIPEMD160Digest();
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte getLength() {
        return (byte)this.engine.getDigestSize();
    }

    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) {
        this.engine.update(inBuff, inOffset, inLength);
        return (short)this.engine.doFinal(outBuff, outOffset);
    }

    public void update(byte[] inBuff, short inOffset, short inLength) {
        this.engine.update(inBuff, inOffset, inLength);
    }

    public void reset() {
        this.engine.reset();
    }
}

