/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.KeyImpl;
import java.security.SecureRandom;
import javacard.security.AESKey;
import javacard.security.CryptoException;
import javacard.security.DESKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.params.KeyParameter;

public class SymmetricKeyImpl
extends KeyImpl
implements DESKey,
AESKey {
    protected ByteContainer key;

    public SymmetricKeyImpl(byte keyType, short keySize) {
        this.size = keySize;
        this.type = keyType;
        switch (keyType) {
            case 2: 
            case 14: {
                this.key = new ByteContainer(2);
                break;
            }
            case 1: 
            case 13: {
                this.key = new ByteContainer(1);
                break;
            }
            case 3: 
            case 15: {
                this.key = new ByteContainer(0);
            }
        }
    }

    public void clearKey() {
        this.key.clear();
    }

    public void setKey(byte[] keyData, short kOff) throws CryptoException, NullPointerException, ArrayIndexOutOfBoundsException {
        this.key.setBytes(keyData, kOff, (short)(this.size / 8));
    }

    public byte getKey(byte[] keyData, short kOff) {
        return (byte)this.key.getBytes(keyData, kOff);
    }

    public CipherParameters getParameters() throws CryptoException {
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new KeyParameter(this.key.getBytes((byte)1));
    }

    public BlockCipher getCipher() throws CryptoException {
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        BlockCipher cipher = null;
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: {
                if (this.size == 64) {
                    cipher = new DESEngine();
                }
                if (this.size != 128 && this.size != 192) break;
                cipher = new DESedeEngine();
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                cipher = new AESEngine();
            }
        }
        return cipher;
    }

    public boolean isInitialized() {
        return this.key.isInitialized();
    }

    public KeyGenerationParameters getKeyGenerationParameters(SecureRandom rnd) {
        return null;
    }
}

