/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import javacard.framework.JCSystem;
import javacard.framework.PIN;
import javacard.framework.PINException;
import javacard.framework.Util;

public class OwnerPIN
implements PIN {
    private static final byte VALIDATED = 0;
    private static final byte NUMFLAGS = 1;
    private byte tryLimit;
    private byte maxPINSize;
    private byte[] pinValue;
    private byte pinSize;
    private boolean[] flags;
    private byte[] triesLeft;

    public OwnerPIN(byte tryLimit, byte maxPINSize) throws PINException {
        if (tryLimit < 1 || maxPINSize < 1) {
            PINException.throwIt((short)1);
        }
        this.pinValue = new byte[maxPINSize];
        this.pinSize = maxPINSize;
        this.maxPINSize = maxPINSize;
        this.tryLimit = tryLimit;
        this.triesLeft = new byte[1];
        this.resetTriesRemaining();
        this.flags = JCSystem.makeTransientBooleanArray((short)1, (byte)1);
        this.setValidatedFlag(false);
    }

    protected boolean getValidatedFlag() {
        return this.flags[0];
    }

    protected void setValidatedFlag(boolean value) {
        this.flags[0] = value;
    }

    private void resetTriesRemaining() {
        Util.arrayFillNonAtomic(this.triesLeft, (short)0, (short)1, this.tryLimit);
    }

    private void decrementTriesRemaining() {
        Util.arrayFillNonAtomic(this.triesLeft, (short)0, (short)1, (byte)(this.triesLeft[0] - 1));
    }

    public byte getTriesRemaining() {
        return this.triesLeft[0];
    }

    public boolean check(byte[] pin, short offset, byte length) throws ArrayIndexOutOfBoundsException, NullPointerException {
        boolean noMoreTries = false;
        this.setValidatedFlag(false);
        if (this.getTriesRemaining() == 0) {
            noMoreTries = true;
        } else {
            this.decrementTriesRemaining();
        }
        if (length > 0) {
            byte tester = pin[(short)(offset + length - 1)];
            if (length != this.pinSize || noMoreTries) {
                return false;
            }
        }
        if (Util.arrayCompare(pin, offset, this.pinValue, (short)0, length) == 0 && length == this.pinSize) {
            this.setValidatedFlag(true);
            this.resetTriesRemaining();
            return true;
        }
        return false;
    }

    public boolean isValidated() {
        return this.getValidatedFlag();
    }

    public void reset() {
        if (this.isValidated()) {
            this.resetAndUnblock();
        }
    }

    public void update(byte[] pin, short offset, byte length) throws PINException {
        if (length > this.maxPINSize) {
            PINException.throwIt((short)1);
        }
        Util.arrayCopy(pin, offset, this.pinValue, (short)0, length);
        this.pinSize = length;
        this.triesLeft[0] = this.tryLimit;
        this.setValidatedFlag(false);
    }

    public void resetAndUnblock() {
        this.resetTriesRemaining();
        this.setValidatedFlag(false);
    }
}

