/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.KeyWithParameters;
import java.lang.reflect.Field;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacard.security.Signature;
import javacard.security.SignatureMessageRecovery;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.SignerWithRecovery;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.ISO9796d2Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;

public class AsymmetricSignatureImpl
extends Signature
implements SignatureMessageRecovery {
    Signer engine;
    Key key;
    byte algorithm;
    boolean isInitialized;
    boolean isRecovery;
    byte[] preSig;

    public AsymmetricSignatureImpl(byte algorithm) {
        this.algorithm = algorithm;
        this.isRecovery = false;
        switch (algorithm) {
            case 9: {
                this.engine = new ISO9796d2Signer(new RSAEngine(), new SHA1Digest());
                break;
            }
            case 30: {
                this.engine = new ISO9796d2Signer(new RSAEngine(), new SHA1Digest());
                this.isRecovery = true;
                break;
            }
            case 10: {
                this.engine = new RSADigestSigner(new SHA1Digest());
                break;
            }
            case 11: {
                this.engine = new RSADigestSigner(new MD5Digest());
                break;
            }
            case 12: {
                this.engine = new ISO9796d2Signer(new RSAEngine(), new RIPEMD160Digest());
                break;
            }
            case 13: {
                this.engine = new RSADigestSigner(new RIPEMD160Digest());
                break;
            }
            case 17: {
                this.engine = new DSADigestSigner(new ECDSASigner(), new SHA1Digest());
            }
        }
    }

    public void init(Key theKey, byte theMode) throws CryptoException {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        this.engine.init(theMode == 1, ((KeyWithParameters)((Object)theKey)).getParameters());
        this.key = theKey;
        this.isInitialized = true;
    }

    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        CryptoException.throwIt((short)1);
    }

    public short getLength() throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        switch (this.algorithm) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return (short)(this.key.getSize() >> 3);
            }
            case 17: {
                return (short)((this.key.getSize() * 2 >> 3) + 8);
            }
        }
        return 0;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public void update(byte[] inBuff, short inOffset, short inLength) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short sign(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset) throws CryptoException {
        if (this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
        try {
            byte[] sig = this.engine.generateSignature();
            Util.arrayCopyNonAtomic(sig, (short)0, sigBuff, sigOffset, (short)sig.length);
            short s = (short)sig.length;
            return s;
        }
        catch (org.bouncycastle.crypto.CryptoException ex) {
            CryptoException.throwIt((short)5);
        }
        catch (DataLengthException ex) {
            CryptoException.throwIt((short)1);
        }
        finally {
            this.engine.reset();
        }
        return -1;
    }

    public boolean verify(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset, short sigLength) throws CryptoException {
        if (this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
        byte[] sig = JCSystem.makeTransientByteArray(sigLength, (byte)1);
        Util.arrayCopyNonAtomic(sigBuff, sigOffset, sig, (short)0, sigLength);
        boolean b = this.engine.verifySignature(sig);
        this.engine.reset();
        return b;
    }

    public short beginVerify(byte[] sigAndRecDataBuff, short buffOffset, short sigLength) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.preSig = JCSystem.makeTransientByteArray(sigLength, (byte)1);
        Util.arrayCopyNonAtomic(sigAndRecDataBuff, buffOffset, this.preSig, (short)0, sigLength);
        try {
            ((SignerWithRecovery)this.engine).updateWithRecoveredMessage(this.preSig);
            return (short)((SignerWithRecovery)this.engine).getRecoveredMessage().length;
        }
        catch (Exception ex) {
            CryptoException.throwIt((short)1);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short sign(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset, short[] recMsgLen, short recMsgLenOffset) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
        try {
            byte[] sig = this.engine.generateSignature();
            Util.arrayCopyNonAtomic(sig, (short)0, sigBuff, sigOffset, (short)sig.length);
            short keyBits = this.key.getSize();
            Field messageLengthField = this.engine.getClass().getDeclaredField("messageLength");
            messageLengthField.setAccessible(true);
            int messageLength = messageLengthField.getInt(this.engine);
            int digSize = 20;
            int x = (digSize + messageLength) * 8 + 16 + 4 - keyBits;
            int mR = messageLength;
            if (x > 0) {
                mR = messageLength - (x + 7) / 8;
            }
            recMsgLen[recMsgLenOffset] = (short)mR;
            short s = (short)sig.length;
            return s;
        }
        catch (org.bouncycastle.crypto.CryptoException ex) {
            CryptoException.throwIt((short)5);
        }
        catch (DataLengthException ex) {
            CryptoException.throwIt((short)1);
        }
        catch (Exception ex) {
            CryptoException.throwIt((short)5);
        }
        finally {
            this.engine.reset();
        }
        return -1;
    }

    public boolean verify(byte[] inBuff, short inOffset, short inLength) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (this.preSig == null) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
        boolean b = this.engine.verifySignature(this.preSig);
        this.engine.reset();
        return b;
    }
}

