/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.RSAKeyImpl;
import javacard.security.CryptoException;
import javacard.security.RSAPrivateCrtKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RSAPrivateCrtKeyImpl
extends RSAKeyImpl
implements RSAPrivateCrtKey {
    protected ByteContainer p = new ByteContainer();
    protected ByteContainer q = new ByteContainer();
    protected ByteContainer dp1 = new ByteContainer();
    protected ByteContainer dq1 = new ByteContainer();
    protected ByteContainer pq = new ByteContainer();

    public RSAPrivateCrtKeyImpl(short keySize) {
        super(true, keySize);
        this.type = (byte)6;
    }

    public RSAPrivateCrtKeyImpl(RSAPrivateCrtKeyParameters params) {
        super(new RSAKeyParameters(true, params.getModulus(), params.getExponent()));
        this.type = (byte)6;
        this.p.setBigInteger(params.getP());
        this.q.setBigInteger(params.getQ());
        this.dp1.setBigInteger(params.getDP());
        this.dq1.setBigInteger(params.getDQ());
        this.pq.setBigInteger(params.getQInv());
    }

    public void setP(byte[] buffer, short offset, short length) throws CryptoException {
        this.p.setBytes(buffer, offset, length);
    }

    public void setQ(byte[] buffer, short offset, short length) throws CryptoException {
        this.q.setBytes(buffer, offset, length);
    }

    public void setDP1(byte[] buffer, short offset, short length) throws CryptoException {
        this.dp1.setBytes(buffer, offset, length);
    }

    public void setDQ1(byte[] buffer, short offset, short length) throws CryptoException {
        this.dq1.setBytes(buffer, offset, length);
    }

    public void setPQ(byte[] buffer, short offset, short length) throws CryptoException {
        this.pq.setBytes(buffer, offset, length);
    }

    public short getP(byte[] buffer, short offset) {
        return this.p.getBytes(buffer, offset);
    }

    public short getQ(byte[] buffer, short offset) {
        return this.q.getBytes(buffer, offset);
    }

    public short getDP1(byte[] buffer, short offset) {
        return this.dp1.getBytes(buffer, offset);
    }

    public short getDQ1(byte[] buffer, short offset) {
        return this.dq1.getBytes(buffer, offset);
    }

    public short getPQ(byte[] buffer, short offset) {
        return this.pq.getBytes(buffer, offset);
    }

    public void clearKey() {
        super.clearKey();
        this.p.clear();
        this.q.clear();
        this.dp1.clear();
        this.dq1.clear();
        this.pq.clear();
    }

    public boolean isInitialized() {
        return this.p.isInitialized() && this.q.isInitialized() && this.dp1.isInitialized() && this.dq1.isInitialized() && this.pq.isInitialized();
    }

    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new RSAPrivateCrtKeyParameters(this.p.getBigInteger().multiply(this.q.getBigInteger()), null, null, this.p.getBigInteger(), this.q.getBigInteger(), this.dp1.getBigInteger(), this.dq1.getBigInteger(), this.pq.getBigInteger());
    }
}

