/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.SymmetricKeyImpl;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacardx.crypto.Cipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SymmetricCipherImpl
extends Cipher {
    byte algorithm;
    BufferedBlockCipher engine;
    boolean isInitialized;

    public SymmetricCipherImpl(byte algorithm) {
        this.algorithm = algorithm;
    }

    public void init(Key theKey, byte theMode) throws CryptoException {
        this.selectCipherEngine(theKey);
        this.engine.init(theMode == 2, ((SymmetricKeyImpl)theKey).getParameters());
        this.isInitialized = true;
    }

    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        switch (this.algorithm) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                CryptoException.throwIt((short)1);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (bLen == 8) break;
                CryptoException.throwIt((short)1);
            }
        }
        this.selectCipherEngine(theKey);
        byte[] iv = JCSystem.makeTransientByteArray(bLen, (byte)1);
        Util.arrayCopyNonAtomic(bArray, bOff, iv, (short)0, bLen);
        this.engine.init(theMode == 2, new ParametersWithIV(((SymmetricKeyImpl)theKey).getParameters(), iv));
        this.isInitialized = true;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        short processedBytes = (short)this.engine.processBytes(inBuff, inOffset, inLength, outBuff, outOffset);
        try {
            return (short)(this.engine.doFinal(outBuff, outOffset + processedBytes) + processedBytes);
        }
        catch (Exception ex) {
            CryptoException.throwIt((short)5);
            return -1;
        }
    }

    public short update(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        return (short)this.engine.processBytes(inBuff, inOffset, inLength, outBuff, outOffset);
    }

    private void selectCipherEngine(Key theKey) {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof SymmetricKeyImpl)) {
            CryptoException.throwIt((short)1);
        }
        SymmetricKeyImpl key = (SymmetricKeyImpl)theKey;
        switch (this.algorithm) {
            case 1: 
            case 13: {
                this.engine = new BufferedBlockCipher(new CBCBlockCipher(key.getCipher()));
                break;
            }
            case 2: {
                this.engine = new PaddedBufferedBlockCipher(new CBCBlockCipher(key.getCipher()), new ZeroBytePadding());
                break;
            }
            case 3: {
                this.engine = new PaddedBufferedBlockCipher(new CBCBlockCipher(key.getCipher()), new ISO7816d4Padding());
                break;
            }
            case 4: {
                this.engine = new PaddedBufferedBlockCipher(new CBCBlockCipher(key.getCipher()), new PKCS7Padding());
                break;
            }
            case 5: 
            case 14: {
                this.engine = new BufferedBlockCipher(key.getCipher());
                break;
            }
            case 6: {
                this.engine = new PaddedBufferedBlockCipher(key.getCipher(), new ZeroBytePadding());
                break;
            }
            case 7: {
                this.engine = new PaddedBufferedBlockCipher(key.getCipher(), new ISO7816d4Padding());
                break;
            }
            case 8: {
                this.engine = new PaddedBufferedBlockCipher(key.getCipher(), new PKCS7Padding());
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
    }
}

