/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.licel.jcardsim.base.SimulatorSystem;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public final class JCSystem {
    public static final byte MEMORY_TYPE_PERSISTENT = 0;
    public static final byte MEMORY_TYPE_TRANSIENT_RESET = 1;
    public static final byte MEMORY_TYPE_TRANSIENT_DESELECT = 2;
    public static final byte NOT_A_TRANSIENT_OBJECT = 0;
    public static final byte CLEAR_ON_RESET = 1;
    public static final byte CLEAR_ON_DESELECT = 2;
    private static final short API_VERSION = 514;
    private static APDU apdu = new APDU();

    public static byte isTransient(Object theObj) {
        return SimulatorSystem.isTransient(theObj);
    }

    public static boolean[] makeTransientBooleanArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.makeTransientBooleanArray(length, event);
    }

    public static byte[] makeTransientByteArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.makeTransientByteArray(length, event);
    }

    public static short[] makeTransientShortArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.makeTransientShortArray(length, event);
    }

    public static Object[] makeTransientObjectArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.makeTransientObjectArray(length, event);
    }

    public static short getVersion() {
        return 514;
    }

    public static AID getAID() {
        return SimulatorSystem.getAID();
    }

    public static AID lookupAID(byte[] buffer, short offset, byte length) {
        return SimulatorSystem.lookupAID(buffer, offset, length);
    }

    public static void beginTransaction() throws TransactionException {
        SimulatorSystem.beginTransaction();
    }

    public static void abortTransaction() throws TransactionException {
        SimulatorSystem.abortTransaction();
    }

    public static void commitTransaction() throws TransactionException {
        SimulatorSystem.commitTransaction();
    }

    public static byte getTransactionDepth() {
        return SimulatorSystem.getTransactionDepth();
    }

    public static short getUnusedCommitCapacity() {
        return SimulatorSystem.getUnusedCommitCapacity();
    }

    public static short getMaxCommitCapacity() {
        return SimulatorSystem.getMaxCommitCapacity();
    }

    public static AID getPreviousContextAID() {
        return SimulatorSystem.getPreviousContextAID();
    }

    public static short getAvailableMemory(byte memoryType) throws SystemException {
        switch (memoryType) {
            case 0: {
                return SimulatorSystem.getAvailablePersistentMemory();
            }
            case 1: {
                return SimulatorSystem.getAvailableTransientResetMemory();
            }
            case 2: {
                return SimulatorSystem.getAvailableTransientDeselectMemory();
            }
        }
        SystemException.throwIt((short)1);
        return 0;
    }

    public static Shareable getAppletShareableInterfaceObject(AID serverAID, byte parameter) {
        return SimulatorSystem.getSharedObject(serverAID, parameter);
    }

    public static boolean isObjectDeletionSupported() {
        return SimulatorSystem.isObjectDeletionSupported();
    }

    public static void requestObjectDeletion() throws SystemException {
        SimulatorSystem.requestObjectDeletion();
    }

    public static byte getAssignedChannel() {
        return SimulatorSystem.getCurrentlySelectedChannel();
    }

    public static boolean isAppletActive(AID theApplet) {
        return SimulatorSystem.isAppletActive(theApplet);
    }
}

