/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.Module;
import com.licel.jcardsim.utils.AIDUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javacard.framework.AID;
import javacard.framework.Applet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoadFile {
    private final AID aid;
    private final List<Module> modules;

    public LoadFile(AID loadFileAID, Module ... modules) {
        if (loadFileAID == null) {
            throw new NullPointerException("loadFileAID");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (modules.length == 0) {
            throw new IllegalArgumentException("modules must not be empty");
        }
        this.aid = loadFileAID;
        this.modules = Collections.unmodifiableList(Arrays.asList(modules));
    }

    public LoadFile(AID loadFileAID, AID moduleAid, Class<? extends Applet> appletClass) {
        this(loadFileAID, new Module(moduleAid, appletClass));
    }

    public AID getAid() {
        return this.aid;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public Module getModule(AID moduleAID) {
        for (Module module : this.modules) {
            if (!module.getAid().equals(moduleAID)) continue;
            return module;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LoadFile ").append(AIDUtil.toString(this.aid)).append("\n");
        for (Module module : this.modules) {
            stringBuilder.append("  ").append(module.toString()).append("\n");
        }
        return stringBuilder.toString();
    }
}

