/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.Checksum;
import javacard.security.CryptoException;

public class CRC32
extends Checksum {
    static final byte LENGTH = 4;
    private byte[] crc32;
    private final byte[] polynom = new byte[]{4, -63, 29, -73};

    public CRC32() {
        this.crc32 = JCSystem.makeTransientByteArray((short)4, (byte)2);
    }

    public byte getAlgorithm() {
        return 2;
    }

    public void init(byte[] bArray, short bOff, short bLen) throws CryptoException {
        if (bLen != 4) {
            CryptoException.throwIt((short)1);
        }
        Util.arrayCopyNonAtomic(bArray, bOff, this.crc32, (short)0, bLen);
    }

    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) {
        this.update(inBuff, inOffset, inLength);
        for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
            int n = i;
            this.crc32[n] = (byte)(this.crc32[n] ^ 0xFF);
        }
        Util.arrayCopy(this.crc32, (short)0, outBuff, outOffset, (short)4);
        Util.arrayFillNonAtomic(this.crc32, (short)0, (short)4, (byte)0);
        return 4;
    }

    public void update(byte[] inBuff, short inOffset, short inLength) {
        this.crc32(inBuff, inOffset, inLength);
    }

    private void crc32(byte[] inBuf, short inOff, short inLen) {
        short fcs_h = Util.getShort(this.crc32, (short)0);
        short fcs_l = Util.getShort(this.crc32, (short)2);
        short poly_h = Util.getShort(this.polynom, (short)0);
        short poly_l = Util.getShort(this.polynom, (short)2);
        boolean carry = false;
        for (short i = inOff; i < (short)(inOff + inLen); i = (short)(i + 1)) {
            short d_h = (short)(inBuf[i] << 8);
            for (int k = 0; k < 8; k = (int)((short)(k + 1))) {
                short lfcs_l;
                short lfcs_h;
                if (((fcs_h ^ d_h) & 0x8000) != 0) {
                    carry = false;
                    lfcs_h = this.shift(fcs_h);
                    if ((fcs_l & 0x8000) != 0) {
                        carry = true;
                    }
                    lfcs_l = this.shift(fcs_l);
                    if (carry) {
                        lfcs_h = (short)(lfcs_h + 1);
                    }
                    fcs_h = (short)(lfcs_h ^ poly_h);
                    fcs_l = (short)(lfcs_l ^ poly_l);
                } else {
                    carry = false;
                    lfcs_h = this.shift(fcs_h);
                    if ((fcs_l & 0x8000) != 0) {
                        carry = true;
                    }
                    lfcs_l = this.shift(fcs_l);
                    if (carry) {
                        lfcs_h = (short)(lfcs_h + 1);
                    }
                    fcs_h = lfcs_h;
                    fcs_l = lfcs_l;
                }
                d_h = (short)(d_h << 1);
            }
        }
        Util.setShort(this.crc32, (short)2, fcs_l);
        Util.setShort(this.crc32, (short)0, fcs_h);
    }

    short shift(short s) {
        s = (short)(s << 1);
        return s;
    }
}

