/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.KeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DSAKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DSAParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DSAValidationParameters;
import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.KeyImpl;
import java.math.BigInteger;
import java.security.SecureRandom;
import javacard.security.CryptoException;
import javacard.security.DSAKey;

public class DSAKeyImpl
extends KeyImpl
implements DSAKey {
    protected ByteContainer p = new ByteContainer();
    protected ByteContainer q = new ByteContainer();
    protected ByteContainer g = new ByteContainer();
    protected boolean isPrivate;

    public DSAKeyImpl(byte keyType, short keySize) {
        this.size = keySize;
        this.type = keyType;
    }

    public DSAKeyImpl(DSAKeyParameters params) {
        this(params.isPrivate() ? (byte)8 : 7, (short)params.getParameters().getP().bitLength());
        this.setParameters(params);
    }

    public void setParameters(CipherParameters params) {
        this.p.setBigInteger(((DSAKeyParameters)params).getParameters().getP());
        this.q.setBigInteger(((DSAKeyParameters)params).getParameters().getQ());
        this.g.setBigInteger(((DSAKeyParameters)params).getParameters().getG());
    }

    public void clearKey() {
        this.p.clear();
        this.q.clear();
        this.g.clear();
    }

    public boolean isInitialized() {
        return this.p.isInitialized() && this.q.isInitialized() && this.g.isInitialized();
    }

    public void setP(byte[] buffer, short offset, short length) throws CryptoException {
        this.p.setBytes(buffer, offset, length);
    }

    public void setQ(byte[] buffer, short offset, short length) throws CryptoException {
        this.q.setBytes(buffer, offset, length);
    }

    public void setG(byte[] buffer, short offset, short length) throws CryptoException {
        this.g.setBytes(buffer, offset, length);
    }

    public short getP(byte[] buffer, short offset) {
        return this.p.getBytes(buffer, offset);
    }

    public short getQ(byte[] buffer, short offset) {
        return this.q.getBytes(buffer, offset);
    }

    public short getG(byte[] buffer, short offset) {
        return this.g.getBytes(buffer, offset);
    }

    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new DSAKeyParameters(this.isPrivate, new DSAParameters(this.p.getBigInteger(), this.q.getBigInteger(), this.g.getBigInteger()));
    }

    public KeyGenerationParameters getKeyGenerationParameters(SecureRandom rnd) {
        if (this.isInitialized()) {
            return new DSAKeyGenerationParameters(rnd, new DSAParameters(this.p.getBigInteger(), this.q.getBigInteger(), this.g.getBigInteger()));
        }
        return DSAKeyImpl.getDefaultKeyGenerationParameters(this.size, rnd);
    }

    static KeyGenerationParameters getDefaultKeyGenerationParameters(short keySize, SecureRandom rnd) {
        BigInteger p = null;
        BigInteger q = null;
        BigInteger g = null;
        BigInteger seed = null;
        int counter = 0;
        switch (keySize) {
            case 512: {
                counter = 123;
                p = new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16);
                q = new BigInteger("962eddcc369cba8ebb260ee6b6a126d9346e38c5", 16);
                g = new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16);
                seed = new BigInteger("b869c82b35d70e1b1ff91b28e37a62ecdc34409b", 16);
                break;
            }
            case 768: {
                counter = 263;
                p = new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16);
                q = new BigInteger("9cdbd84c9f1ac2f38d0f80f42ab952e7338bf511", 16);
                g = new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16);
                seed = new BigInteger("77d0f8c4dad15eb8c4f2f8d6726cefd96d5bb399", 16);
                break;
            }
            case 1024: {
                counter = 92;
                p = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
                q = new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16);
                g = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
                seed = new BigInteger("8d5155894229d5e689ee01e6018a237e2cae64cd", 16);
                break;
            }
            default: {
                CryptoException.throwIt((short)1);
            }
        }
        return new DSAKeyGenerationParameters(rnd, new DSAParameters(p, q, g, new DSAValidationParameters(seed.toByteArray(), counter)));
    }
}

