/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.framework.service;

import com.licel.jcardsim.base.SimulatorSystem;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.framework.service.Dispatcher;
import javacard.framework.service.Service;
import javacard.framework.service.ServiceException;

public class DispatcherImpl
extends Dispatcher {
    private short _maxServices;
    private Service[] _services;
    private byte[] _phases;

    public DispatcherImpl(short maxServices) throws ServiceException {
        super(maxServices);
        this._services = new Service[maxServices];
        SimulatorSystem.instance().setJavaOwner(this._services, this);
        this._phases = new byte[maxServices];
        SimulatorSystem.instance().setJavaOwner(this._phases, this);
        this._maxServices = maxServices;
    }

    public void addService(Service service, byte phase) throws ServiceException {
        boolean doTrans;
        if (phase <= 0 || phase > 3 || service == null) {
            ServiceException.throwIt((short)1);
        }
        short index = this._maxServices;
        for (short i = 0; i < this._maxServices; i = (short)(i + 1)) {
            if (this._services[i] == null && index == this._maxServices) {
                index = i;
            }
            if (this._services[i] != service || this._phases[i] != phase) continue;
            return;
        }
        if (index == this._maxServices) {
            ServiceException.throwIt((short)2);
        }
        boolean bl = doTrans = JCSystem.getTransactionDepth() == 0;
        if (doTrans) {
            JCSystem.beginTransaction();
        }
        this._services[index] = service;
        this._phases[index] = phase;
        if (doTrans) {
            JCSystem.commitTransaction();
        }
    }

    public void removeService(Service service, byte phase) throws ServiceException {
        short i;
        if (phase <= 0 || phase > 3 || service == null) {
            ServiceException.throwIt((short)1);
        }
        for (i = 0; i < this._maxServices && (this._services[i] != service || this._phases[i] != phase); i = (short)(i + 1)) {
        }
        if (i != this._maxServices) {
            boolean doTrans;
            boolean bl = doTrans = JCSystem.getTransactionDepth() == 0;
            if (doTrans) {
                JCSystem.beginTransaction();
            }
            this._services[i] = null;
            this._phases[i] = 0;
            if (doTrans) {
                JCSystem.commitTransaction();
            }
        }
    }

    public Exception dispatch(APDU command, byte phase) throws ServiceException {
        if (phase <= 0 || phase > 3) {
            ServiceException.throwIt((short)1);
        }
        Exception result = null;
        try {
            for (byte phases = phase; phases <= 3; phases = (byte)(phases + 1)) {
                this.dispatchPhase(command, phases);
            }
        }
        catch (Exception e) {
            result = e;
        }
        return result;
    }

    private void dispatchPhase(APDU command, byte phase) {
        for (short service = 0; service < this._maxServices && this._services[service] != null && this._phases[service] == phase; service = (short)(service + 1)) {
            if (phase == 1) {
                if (!this._services[service].processDataIn(command)) continue;
                return;
            }
            if (phase == 2) {
                if (!this._services[service].processCommand(command)) continue;
                return;
            }
            if (command.getCurrentState() == 3) {
                if (!this._services[service].processDataOut(command)) continue;
                short len = (short)(command.getBuffer()[4] & 0xFF);
                command.setOutgoingLength(len);
                command.sendBytes((short)5, len);
                ISOException.throwIt(Util.makeShort(command.getBuffer()[2], command.getBuffer()[3]));
                continue;
            }
            return;
        }
    }

    public void process(APDU command) throws ISOException {
        Exception e = this.dispatch(command, (byte)1);
        if (e instanceof ISOException && ((ISOException)e).getReason() != -28672) {
            throw (ISOException)e;
        }
        if (e == null) {
            ISOException.throwIt((short)27904);
        }
        ISOException.throwIt((short)28416);
    }
}

