/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public final class AutoResetEvent {
    private static final int SIGNALED = 1;
    private static final int NOT_SIGNALED = 0;
    private final Sync sync = new Sync();

    public void signal() {
        this.sync.releaseShared(1);
    }

    public void reset() {
        this.sync.releaseShared(0);
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(time));
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        Sync() {
            this.setState(0);
        }

        protected int tryAcquireShared(int ignore) {
            if (this.compareAndSetState(1, 0)) {
                return 1;
            }
            return -1;
        }

        protected boolean tryReleaseShared(int state) {
            this.setState(state);
            return true;
        }
    }
}

