/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.router.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterContactImpl;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTRouterNodeImpl {
    private DHTRouterImpl router;
    private int depth;
    private boolean contains_router_node_id;
    private List<DHTRouterContactImpl> buckets;
    private List<DHTRouterContactImpl> replacements;
    private DHTRouterNodeImpl left;
    private DHTRouterNodeImpl right;
    private long last_lookup_time;

    protected DHTRouterNodeImpl(DHTRouterImpl _router, int _depth, boolean _contains_router_node_id, List<DHTRouterContactImpl> _buckets) {
        this.router = _router;
        this.depth = _depth;
        this.contains_router_node_id = _contains_router_node_id;
        this.buckets = _buckets;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected boolean containsRouterNodeID() {
        return this.contains_router_node_id;
    }

    protected DHTRouterNodeImpl getLeft() {
        return this.left;
    }

    protected DHTRouterNodeImpl getRight() {
        return this.right;
    }

    protected void split(DHTRouterNodeImpl new_left, DHTRouterNodeImpl new_right) {
        this.buckets = null;
        if (this.replacements != null) {
            for (DHTRouterContactImpl rep : this.replacements) {
                this.router.notifyRemoved(rep);
            }
            this.replacements = null;
        }
        this.left = new_left;
        this.right = new_right;
    }

    protected List getBuckets() {
        return this.buckets;
    }

    protected List<DHTRouterContactImpl> getReplacements() {
        return this.replacements;
    }

    protected void addNode(DHTRouterContactImpl node) {
        node.setBucketEntry();
        this.router.notifyAdded(node);
        this.buckets.add(node);
        this.requestNodeAdd(node, false);
    }

    protected DHTRouterContact addReplacement(DHTRouterContactImpl replacement, int max_rep_per_node) {
        if (max_rep_per_node == 0) {
            return null;
        }
        boolean try_ping = false;
        if (this.replacements == null) {
            try_ping = true;
            this.replacements = new ArrayList<DHTRouterContactImpl>();
        } else if (this.replacements.size() == max_rep_per_node) {
            DHTRouterContactImpl r;
            if (replacement.hasBeenAlive()) {
                int i = 0;
                while (i < this.replacements.size()) {
                    r = this.replacements.get(i);
                    if (!r.hasBeenAlive()) {
                        try_ping = true;
                        this.router.notifyRemoved(r);
                        this.replacements.remove(i);
                        break;
                    }
                    ++i;
                }
                if (this.replacements.size() == max_rep_per_node) {
                    DHTRouterContactImpl removed = this.replacements.remove(0);
                    this.router.notifyRemoved(removed);
                }
            } else {
                int i = 0;
                while (i < this.replacements.size()) {
                    r = this.replacements.get(i);
                    if (!r.hasBeenAlive()) {
                        this.router.notifyRemoved(r);
                        this.replacements.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            try_ping = true;
        }
        if (this.replacements.size() == max_rep_per_node) {
            return null;
        }
        replacement.setReplacement();
        this.router.notifyAdded(replacement);
        this.replacements.add(replacement);
        if (try_ping) {
            int i = 0;
            while (i < this.buckets.size()) {
                DHTRouterContactImpl c = this.buckets.get(i);
                if (!this.router.isID(c.getID()) && !c.getPingOutstanding()) {
                    c.setPingOutstanding(true);
                    this.router.requestPing(c);
                    break;
                }
                ++i;
            }
        }
        return replacement;
    }

    protected DHTRouterContactImpl updateExistingNode(byte[] node_id, DHTRouterContactAttachment attachment, boolean known_to_be_alive) {
        DHTRouterContactImpl contact;
        int k = 0;
        while (k < this.buckets.size()) {
            contact = this.buckets.get(k);
            if (Arrays.equals(node_id, contact.getID())) {
                int old_id;
                int new_id;
                if (known_to_be_alive) {
                    this.alive(contact);
                }
                if ((new_id = attachment.getInstanceID()) != 0 && (old_id = contact.getAttachment().getInstanceID()) != new_id) {
                    DHTLog.log("Instance ID changed for " + DHTLog.getString(contact.getID()) + ": old = " + old_id + ", new = " + new_id);
                    contact.setAttachment(attachment);
                    this.requestNodeAdd(contact, old_id != 0);
                }
                return contact;
            }
            ++k;
        }
        if (this.replacements != null) {
            k = 0;
            while (k < this.replacements.size()) {
                contact = this.replacements.get(k);
                if (Arrays.equals(node_id, contact.getID())) {
                    if (known_to_be_alive) {
                        this.alive(contact);
                    }
                    return contact;
                }
                ++k;
            }
        }
        return null;
    }

    protected void alive(DHTRouterContactImpl contact) {
        contact.setPingOutstanding(false);
        boolean was_alive = contact.isAlive();
        if (this.buckets.remove(contact)) {
            contact.setAlive();
            if (!was_alive) {
                this.router.notifyNowAlive(contact);
            }
            this.buckets.add(contact);
        } else if (this.replacements.remove(contact)) {
            long last_time = contact.getFirstFailOrLastAliveTime();
            contact.setAlive();
            if (!was_alive) {
                this.router.notifyNowAlive(contact);
            }
            if (contact.getLastAliveTime() - last_time > 30000L) {
                int i = 0;
                while (i < this.buckets.size()) {
                    DHTRouterContactImpl c = this.buckets.get(i);
                    if (!this.router.isID(c.getID()) && !c.getPingOutstanding()) {
                        c.setPingOutstanding(true);
                        this.router.requestPing(c);
                        break;
                    }
                    ++i;
                }
            }
            this.replacements.add(contact);
        }
    }

    protected void dead(DHTRouterContactImpl contact, boolean force) {
        contact.setPingOutstanding(false);
        boolean was_failing = contact.isFailing();
        if (contact.setFailed() || force) {
            if (this.buckets.remove(contact)) {
                if (!was_failing) {
                    this.router.notifyNowFailing(contact);
                }
                this.router.notifyRemoved(contact);
                if (this.replacements != null && this.replacements.size() > 0) {
                    boolean replaced = false;
                    int i = this.replacements.size() - 1;
                    while (i >= 0) {
                        DHTRouterContactImpl rep = this.replacements.get(i);
                        if (rep.hasBeenAlive()) {
                            DHTLog.log(String.valueOf(DHTLog.getString(contact.getID())) + ": using live replacement " + DHTLog.getString(rep.getID()));
                            rep.setBucketEntry();
                            this.router.notifyLocationChanged(rep);
                            this.replacements.remove(rep);
                            this.buckets.add(rep);
                            replaced = true;
                            this.requestNodeAdd(rep, false);
                            break;
                        }
                        --i;
                    }
                    if (!replaced) {
                        DHTRouterContactImpl rep = this.replacements.remove(this.replacements.size() - 1);
                        DHTLog.log(String.valueOf(DHTLog.getString(contact.getID())) + ": using unknown replacement " + DHTLog.getString(rep.getID()));
                        rep.setBucketEntry();
                        this.router.notifyLocationChanged(rep);
                        this.buckets.add(rep);
                        this.requestNodeAdd(rep, false);
                    }
                }
            } else {
                if (!was_failing) {
                    this.router.notifyNowFailing(contact);
                }
                this.router.notifyRemoved(contact);
                this.replacements.remove(contact);
            }
        }
    }

    protected void requestNodeAdd(DHTRouterContactImpl contact, boolean definite_change) {
        long now = SystemTime.getCurrentTime();
        if (now - contact.getLastAddedTime() > 10000L) {
            contact.setLastAddedTime(now);
            this.router.requestNodeAdd(contact);
        } else if (definite_change) {
            this.router.log("requestNodeAdd for " + contact.getString() + " denied as too soon after previous ");
        }
    }

    protected long getTimeSinceLastLookup() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_lookup_time) {
            return Long.MAX_VALUE;
        }
        return now - this.last_lookup_time;
    }

    protected void setLastLookupTime() {
        this.last_lookup_time = SystemTime.getCurrentTime();
    }

    public void print(String indent, String prefix) {
        if (this.left == null) {
            this.router.log(String.valueOf(indent) + prefix + ": buckets = " + this.buckets.size() + this.contactsToString(this.buckets) + ", replacements = " + (this.replacements == null ? "null" : String.valueOf(this.replacements.size()) + this.contactsToString(this.replacements)) + (this.contains_router_node_id ? " *" : " ") + (this == this.router.getSmallestSubtree() ? "SST" : "") + " tsll=" + this.getTimeSinceLastLookup());
        } else {
            this.router.log(String.valueOf(indent) + prefix + ":" + (this.contains_router_node_id ? " *" : " ") + (this == this.router.getSmallestSubtree() ? "SST" : ""));
            this.left.print(String.valueOf(indent) + "  ", String.valueOf(prefix) + "1");
            this.right.print(String.valueOf(indent) + "  ", String.valueOf(prefix) + "0");
        }
    }

    protected String contactsToString(List contacts) {
        StringBuilder sb = new StringBuilder(contacts.size() * 64);
        sb.append("{");
        int i = 0;
        while (i < contacts.size()) {
            if (i > 0) {
                sb.append(", ");
            }
            ((DHTRouterContactImpl)contacts.get(i)).getString(sb);
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

