/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManager;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import org.gudy.azureus2.core3.util.AEMonitor;

public class CacheFileManagerFactory {
    public static final String DEFAULT_MANAGER = "com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl";
    private static CacheFileManager manager;
    private static AEMonitor class_mon;

    static {
        class_mon = new AEMonitor("CacheFileManagerFactory");
    }

    public static CacheFileManager getSingleton() throws CacheFileManagerException {
        return CacheFileManagerFactory.getSingleton(null);
    }

    public static CacheFileManager getSingleton(String explicit_implementation) throws CacheFileManagerException {
        try {
            class_mon.enter();
            if (manager == null) {
                String impl = explicit_implementation;
                if (impl == null) {
                    impl = System.getProperty("com.aelitis.azureus.core.diskmanager.cache.manager");
                }
                if (impl == null) {
                    impl = DEFAULT_MANAGER;
                }
                try {
                    Class<?> impl_class = CacheFileManagerFactory.class.getClassLoader().loadClass(impl);
                    manager = (CacheFileManager)impl_class.newInstance();
                }
                catch (Throwable e) {
                    throw new CacheFileManagerException(null, "Failed to instantiate manager '" + impl + "'", e);
                }
            }
            CacheFileManager cacheFileManager = manager;
            return cacheFileManager;
        }
        finally {
            class_mon.exit();
        }
    }
}

