/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.drivedetector.impl;

import com.aelitis.azureus.core.drivedetector.DriveDetectedInfo;
import com.aelitis.azureus.core.drivedetector.DriveDetectedListener;
import com.aelitis.azureus.core.drivedetector.DriveDetector;
import com.aelitis.azureus.core.drivedetector.DriveDetectorFactory;
import com.aelitis.azureus.core.drivedetector.impl.DriveDetectedInfoImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class DriveDetectorImpl
implements DriveDetector,
AEDiagnosticsEvidenceGenerator {
    private AEMonitor2 mon_driveDetector = new AEMonitor2("driveDetector");
    private CopyOnWriteList<DriveDetectedListener> listListeners = new CopyOnWriteList(1);
    private Map<File, Map> mapDrives = new HashMap<File, Map>(1);
    private AsyncDispatcher dispatcher = new AsyncDispatcher("DriveDetector");

    public DriveDetectorImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
    }

    @Override
    public DriveDetectedInfo[] getDetectedDriveInfo() {
        this.mon_driveDetector.enter();
        try {
            int i = 0;
            DriveDetectedInfo[] ddi = new DriveDetectedInfo[this.mapDrives.size()];
            for (File key : this.mapDrives.keySet()) {
                ddi[i++] = new DriveDetectedInfoImpl(key, this.mapDrives.get(key));
            }
            DriveDetectedInfo[] driveDetectedInfoArray = ddi;
            return driveDetectedInfoArray;
        }
        finally {
            this.mon_driveDetector.exit();
        }
    }

    @Override
    public void addListener(DriveDetectedListener l) {
        this.mon_driveDetector.enter();
        try {
            if (this.listListeners.contains(l)) {
                return;
            }
            this.listListeners.add(l);
            for (File key : this.mapDrives.keySet()) {
                try {
                    l.driveDetected(new DriveDetectedInfoImpl(key, this.mapDrives.get(key)));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        finally {
            this.mon_driveDetector.exit();
        }
    }

    @Override
    public void removeListener(DriveDetectedListener l) {
        this.listListeners.remove(l);
    }

    @Override
    public void driveDetected(final File _location, final Map info) {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                File location;
                block7: {
                    location = DriveDetectorImpl.this.normaliseFile(_location);
                    DriveDetectorImpl.this.mon_driveDetector.enter();
                    try {
                        if (!DriveDetectorImpl.this.mapDrives.containsKey(location)) {
                            info.put("File", location);
                            DriveDetectorImpl.this.mapDrives.put(location, info);
                            break block7;
                        }
                        return;
                    }
                    finally {
                        DriveDetectorImpl.this.mon_driveDetector.exit();
                    }
                }
                for (DriveDetectedListener l : DriveDetectorImpl.this.listListeners) {
                    try {
                        l.driveDetected(new DriveDetectedInfoImpl(location, info));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    @Override
    public void driveRemoved(final File _location) {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                Map map;
                File location = DriveDetectorImpl.this.normaliseFile(_location);
                DriveDetectorImpl.this.mon_driveDetector.enter();
                try {
                    map = (Map)DriveDetectorImpl.this.mapDrives.remove(location);
                    if (map == null) {
                        return;
                    }
                }
                finally {
                    DriveDetectorImpl.this.mon_driveDetector.exit();
                }
                for (DriveDetectedListener l : DriveDetectorImpl.this.listListeners) {
                    try {
                        l.driveRemoved(new DriveDetectedInfoImpl(location, map));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    private File normaliseFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Throwable e) {
            Debug.out(e);
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        Map<File, Map> map = this.mapDrives;
        synchronized (map) {
            writer.println("DriveDetector: " + this.mapDrives.size() + " drives");
            for (File file : this.mapDrives.keySet()) {
                try {
                    try {
                        writer.indent();
                        writer.println(file.getPath());
                        try {
                            writer.indent();
                            Map driveInfo = this.mapDrives.get(file);
                            for (Object key : driveInfo.keySet()) {
                                Object val = driveInfo.get(key);
                                writer.println(key + ": " + val);
                            }
                        }
                        finally {
                            writer.exdent();
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        writer.exdent();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    writer.exdent();
                    throw throwable;
                }
                writer.exdent();
            }
        }
    }

    public static void main(String[] args) {
        DriveDetectedInfo[] infos;
        DriveDetectedInfo[] driveDetectedInfoArray = infos = DriveDetectorFactory.getDeviceDetector().getDetectedDriveInfo();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            DriveDetectedInfo info = driveDetectedInfoArray[n2];
            System.out.println(info.getLocation());
            Map<String, Object> infoMap = info.getInfoMap();
            for (String key : infoMap.keySet()) {
                Object val = infoMap.get(key);
                System.out.println("\t" + key + ": " + val);
            }
            ++n2;
        }
    }
}

