/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminNATUDPReply;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminNATUDPRequest;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class NetworkAdminNATUDPCodecs {
    public static final int ACT_NAT_REQUEST = 40;
    public static final int ACT_NAT_REPLY = 41;
    private static boolean registered = false;

    static {
        NetworkAdminNATUDPCodecs.registerCodecs();
    }

    public static void registerCodecs() {
        if (registered) {
            return;
        }
        registered = true;
        PRUDPPacketReplyDecoder reply_decoder = new PRUDPPacketReplyDecoder(){

            @Override
            public PRUDPPacketReply decode(PRUDPPacketHandler handler, InetSocketAddress originator, DataInputStream is, int action, int transaction_id) throws IOException {
                switch (action) {
                    case 41: {
                        return new NetworkAdminNATUDPReply(is, transaction_id);
                    }
                }
                throw new IOException("Unrecognised action '" + action + "'");
            }
        };
        HashMap<Integer, 1> reply_decoders = new HashMap<Integer, 1>();
        reply_decoders.put(new Integer(41), reply_decoder);
        PRUDPPacketReply.registerDecoders(reply_decoders);
        PRUDPPacketRequestDecoder request_decoder = new PRUDPPacketRequestDecoder(){

            @Override
            public PRUDPPacketRequest decode(PRUDPPacketHandler handler, DataInputStream is, long connection_id, int action, int transaction_id) throws IOException {
                switch (action) {
                    case 40: {
                        return new NetworkAdminNATUDPRequest(is, connection_id, transaction_id);
                    }
                }
                throw new IOException("unsupported request type");
            }
        };
        HashMap<Integer, 2> request_decoders = new HashMap<Integer, 2>();
        request_decoders.put(new Integer(40), request_decoder);
        PRUDPPacketRequest.registerDecoders(request_decoders);
    }
}

