/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterStreamXOR
extends TransportHelperFilterStream {
    private byte[] mask;
    private int read_position;
    private int write_position;

    protected TransportHelperFilterStreamXOR(TransportHelper _transport, byte[] _mask) {
        super(_transport);
        this.mask = _mask;
    }

    @Override
    protected void cryptoOut(ByteBuffer source_buffer, ByteBuffer target_buffer) throws IOException {
        int rem = source_buffer.remaining();
        int i = 0;
        while (i < rem) {
            byte b = source_buffer.get();
            b = (byte)(b ^ this.mask[this.write_position++]);
            target_buffer.put(b);
            if (this.write_position == this.mask.length) {
                this.write_position = 0;
            }
            ++i;
        }
    }

    @Override
    protected void cryptoIn(ByteBuffer source_buffer, ByteBuffer target_buffer) throws IOException {
        int rem = source_buffer.remaining();
        int i = 0;
        while (i < rem) {
            byte b = source_buffer.get();
            b = (byte)(b ^ this.mask[this.read_position++]);
            target_buffer.put(b);
            if (this.read_position == this.mask.length) {
                this.read_position = 0;
            }
            ++i;
        }
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public String getName(boolean verbose) {
        String proto_str = this.getHelper().getName(verbose);
        if (proto_str.length() > 0) {
            proto_str = " (" + proto_str + ")";
        }
        return "XOR-" + this.mask.length * 8 + proto_str;
    }
}

