/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlue;
import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlueListener;
import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlueUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnection;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionSet;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransport;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransportHelper;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class UDPConnectionManager
implements NetworkGlueListener {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final boolean LOOPBACK = false;
    private static final boolean FORCE_LOG = false;
    private static boolean LOG = false;
    private static int max_outbound_connections;
    public static final int TIMER_TICK_MILLIS = 25;
    public static final int THREAD_LINGER_ON_IDLE_PERIOD = 30000;
    public static final int DEAD_KEY_RETENTION_PERIOD = 30000;
    public static final int STATS_TIME = 60000;
    public static final int STATS_TICKS = 2400;
    private final Map connection_sets = new HashMap();
    private final Map recently_dead_keys = new HashMap();
    private int next_connection_id;
    private IncomingConnectionManager incoming_manager = IncomingConnectionManager.getSingleton();
    private NetworkGlue network_glue;
    private UDPSelector selector;
    private ProtocolTimer protocol_timer;
    private long idle_start;
    private static final int BLOOM_RECREATE = 30000;
    private static final int BLOOM_INCREASE = 1000;
    private BloomFilter incoming_bloom = BloomFilterFactory.createAddRemove4Bit(1000);
    private long incoming_bloom_create_time = SystemTime.getCurrentTime();
    private long last_incoming;
    private int rate_limit_discard_packets;
    private int rate_limit_discard_bytes;
    private int setup_discard_packets;
    private int setup_discard_bytes;
    private volatile int outbound_connection_count;
    private boolean max_conn_exceeded_logged;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Logging Enable UDP Transport", "network.udp.max.connections.outstanding"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                LOG = COConfigurationManager.getBooleanParameter("Logging Enable UDP Transport");
                max_outbound_connections = COConfigurationManager.getIntParameter("network.udp.max.connections.outstanding", 2048);
            }
        });
    }

    protected UDPConnectionManager() {
        this.network_glue = new NetworkGlueUDP(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectOutbound(final UDPTransport udp_transport, final InetSocketAddress address, byte[][] shared_secrets, ByteBuffer initial_data, final Transport.ConnectListener listener) {
        UDPTransportHelper helper = null;
        try {
            if (address.isUnresolved()) {
                listener.connectFailure(new UnknownHostException(address.getHostName()));
                return;
            }
            int time = listener.connectAttemptStarted(-1);
            if (time != -1) {
                Debug.out("UDP connect time override not supported");
            }
            final UDPTransportHelper f_helper = helper = new UDPTransportHelper(this, address, udp_transport);
            UDPConnectionManager uDPConnectionManager = this;
            synchronized (uDPConnectionManager) {
                ++this.outbound_connection_count;
                if (this.outbound_connection_count >= max_outbound_connections && !this.max_conn_exceeded_logged) {
                    this.max_conn_exceeded_logged = true;
                    Debug.out("UDPConnectionManager: max outbound connection limit reached (" + max_outbound_connections + ")");
                }
            }
            try {
                TransportCryptoManager.getSingleton().manageCrypto(helper, shared_secrets, false, initial_data, new TransportCryptoManager.HandshakeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                        UDPConnectionManager uDPConnectionManager = UDPConnectionManager.this;
                        synchronized (uDPConnectionManager) {
                            if (UDPConnectionManager.this.outbound_connection_count > 0) {
                                UDPConnectionManager uDPConnectionManager2 = UDPConnectionManager.this;
                                uDPConnectionManager2.outbound_connection_count = uDPConnectionManager2.outbound_connection_count - 1;
                            }
                        }
                        TransportHelperFilter filter2 = decoder.getFilter();
                        try {
                            udp_transport.setFilter(filter2);
                            if (udp_transport.isClosed()) {
                                udp_transport.close("Already closed");
                                listener.connectFailure(new Exception("Connection already closed"));
                            } else {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "Outgoing UDP stream to " + address + " established, type = " + filter2.getName(false)));
                                }
                                udp_transport.connectedOutbound();
                                listener.connectSuccess(udp_transport, remaining_initial_data);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            udp_transport.close(Debug.getNestedExceptionMessageAndStack(e));
                            listener.connectFailure(e);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handshakeFailure(Throwable failure_msg) {
                        UDPConnectionManager uDPConnectionManager = UDPConnectionManager.this;
                        synchronized (uDPConnectionManager) {
                            if (UDPConnectionManager.this.outbound_connection_count > 0) {
                                UDPConnectionManager uDPConnectionManager2 = UDPConnectionManager.this;
                                uDPConnectionManager2.outbound_connection_count = uDPConnectionManager2.outbound_connection_count - 1;
                            }
                        }
                        f_helper.close(Debug.getNestedExceptionMessageAndStack(failure_msg));
                        listener.connectFailure(failure_msg);
                    }

                    @Override
                    public void gotSecret(byte[] session_secret) {
                        f_helper.getConnection().setSecret(session_secret);
                    }

                    @Override
                    public int getMaximumPlainHeaderLength() {
                        throw new RuntimeException();
                    }

                    @Override
                    public int matchPlainHeader(ByteBuffer buffer) {
                        throw new RuntimeException();
                    }
                });
            }
            catch (Throwable e) {
                UDPConnectionManager uDPConnectionManager2 = this;
                synchronized (uDPConnectionManager2) {
                    if (this.outbound_connection_count > 0) {
                        --this.outbound_connection_count;
                    }
                }
                throw e;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            if (helper != null) {
                helper.close(Debug.getNestedExceptionMessage(e));
            }
            listener.connectFailure(e);
        }
    }

    public int getMaxOutboundPermitted() {
        return Math.max(max_outbound_connections - this.outbound_connection_count, 0);
    }

    protected UDPSelector checkThreadCreation() {
        if (this.selector == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "UDPConnectionManager: activating"));
            }
            this.idle_start = SystemTime.getMonotonousTime();
            this.selector = new UDPSelector(this);
            this.protocol_timer = new ProtocolTimer();
        }
        return this.selector;
    }

    protected void checkThreadDeath(boolean connections_running) {
        if (connections_running) {
            this.idle_start = 0L;
        } else {
            long now = SystemTime.getMonotonousTime();
            if (this.idle_start == 0L) {
                this.idle_start = now;
            } else if (now - this.idle_start > 30000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "UDPConnectionManager: deactivating"));
                }
                this.selector.destroy();
                this.selector = null;
                this.protocol_timer.destroy();
                this.protocol_timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        Map map = this.connection_sets;
        synchronized (map) {
            Iterator it = this.connection_sets.values().iterator();
            while (it.hasNext()) {
                ((UDPConnectionSet)it.next()).poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UDPConnectionSet set, UDPConnection connection) {
        Map map = this.connection_sets;
        synchronized (map) {
            if (set.remove(connection)) {
                String key = set.getKey();
                if (set.hasFailed() && this.connection_sets.remove(key) != null) {
                    set.removed();
                    this.recently_dead_keys.put(key, new Long(SystemTime.getCurrentTime()));
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Connection set " + key + " failed"));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(UDPConnectionSet set) {
        Map map = this.connection_sets;
        synchronized (map) {
            String key = set.getKey();
            if (this.connection_sets.remove(key) != null) {
                set.removed();
                this.recently_dead_keys.put(key, new Long(SystemTime.getCurrentTime()));
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Connection set " + key + " failed"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UDPConnection registerOutgoing(UDPTransportHelper helper) throws IOException {
        int local_port = UDPNetworkManager.getSingleton().getUDPListeningPortNumber();
        InetSocketAddress address = helper.getAddress();
        String key = String.valueOf(local_port) + ":" + address.getAddress().getHostAddress() + ":" + address.getPort();
        Map map = this.connection_sets;
        synchronized (map) {
            UDPSelector current_selector = this.checkThreadCreation();
            UDPConnectionSet connection_set = (UDPConnectionSet)this.connection_sets.get(key);
            if (connection_set == null) {
                this.timeoutDeadKeys();
                connection_set = new UDPConnectionSet(this, key, current_selector, local_port, address);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Created new set - " + connection_set.getName() + ", outgoing"));
                }
                this.connection_sets.put(key, connection_set);
            }
            UDPConnection connection = new UDPConnection(connection_set, this.allocationConnectionID(), helper);
            connection_set.add(connection);
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(int local_port, InetSocketAddress remote_address, byte[] data, int data_length) {
        UDPConnectionSet connection_set;
        String key = String.valueOf(local_port) + ":" + remote_address.getAddress().getHostAddress() + ":" + remote_address.getPort();
        Map map = this.connection_sets;
        synchronized (map) {
            UDPSelector current_selector = this.checkThreadCreation();
            connection_set = (UDPConnectionSet)this.connection_sets.get(key);
            if (connection_set == null) {
                this.timeoutDeadKeys();
                if (data_length >= UDPNetworkManager.MIN_INCOMING_INITIAL_PACKET_SIZE && data_length <= UDPNetworkManager.MAX_INCOMING_INITIAL_PACKET_SIZE) {
                    if (!this.rateLimitIncoming(remote_address)) {
                        ++this.rate_limit_discard_packets;
                        this.rate_limit_discard_bytes += data_length;
                        return;
                    }
                    connection_set = new UDPConnectionSet(this, key, current_selector, local_port, remote_address);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Created new set - " + connection_set.getName() + ", incoming"));
                    }
                    this.connection_sets.put(key, connection_set);
                } else {
                    this.recently_dead_keys.get(key);
                    ++this.setup_discard_packets;
                    this.setup_discard_bytes += data_length;
                    return;
                }
            }
        }
        try {
            connection_set.receive(data, data_length);
        }
        catch (IOException e) {
            connection_set.failed(e);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            connection_set.failed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rateLimitIncoming(InetSocketAddress s_address) {
        long delay;
        long now = SystemTime.getCurrentTime();
        byte[] address = s_address.getAddress().getAddress();
        UDPConnectionManager uDPConnectionManager = this;
        synchronized (uDPConnectionManager) {
            block10: {
                int hit_count = this.incoming_bloom.add(address);
                if (this.incoming_bloom.getSize() / this.incoming_bloom.getEntryCount() < 10) {
                    this.incoming_bloom = BloomFilterFactory.createAddRemove4Bit(this.incoming_bloom.getSize() + 1000);
                    this.incoming_bloom_create_time = now;
                    Logger.log(new LogEvent(LOGID, "UDP connnection bloom: size increased to " + this.incoming_bloom.getSize()));
                } else if (now < this.incoming_bloom_create_time || now - this.incoming_bloom_create_time > 30000L) {
                    this.incoming_bloom = BloomFilterFactory.createAddRemove4Bit(this.incoming_bloom.getSize());
                    this.incoming_bloom_create_time = now;
                }
                if (hit_count < 15) break block10;
                Logger.log(new LogEvent(LOGID, "UDP incoming: too many recent connection attempts from " + s_address));
                return false;
            }
            long since_last = now - this.last_incoming;
            delay = 100L - since_last;
            this.last_incoming = now;
        }
        if (delay > 0L && delay < 100L) {
            try {
                Thread.sleep(delay);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public int send(int local_port, InetSocketAddress remote_address, byte[] data) throws IOException {
        return this.network_glue.send(local_port, remote_address, data);
    }

    protected void accept(final int local_port, final InetSocketAddress remote_address, final UDPConnection connection) {
        final UDPTransportHelper helper = new UDPTransportHelper(this, remote_address, connection);
        try {
            connection.setTransport(helper);
            TransportCryptoManager.getSingleton().manageCrypto(helper, null, true, null, new TransportCryptoManager.HandshakeListener(){

                @Override
                public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    TransportHelperFilter filter2 = decoder.getFilter();
                    ConnectionEndpoint co_ep = new ConnectionEndpoint(remote_address);
                    ProtocolEndpointUDP pe_udp = (ProtocolEndpointUDP)ProtocolEndpointFactory.createEndpoint(2, co_ep, remote_address);
                    UDPTransport transport = new UDPTransport(pe_udp, filter2);
                    helper.setTransport(transport);
                    UDPConnectionManager.this.incoming_manager.addConnection(local_port, filter2, transport);
                }

                @Override
                public void handshakeFailure(Throwable failure_msg) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "incoming crypto handshake failure: " + Debug.getNestedExceptionMessage(failure_msg)));
                    }
                    connection.close("handshake failure: " + Debug.getNestedExceptionMessage(failure_msg));
                }

                @Override
                public void gotSecret(byte[] session_secret) {
                    helper.getConnection().setSecret(session_secret);
                }

                @Override
                public int getMaximumPlainHeaderLength() {
                    return UDPConnectionManager.this.incoming_manager.getMaxMinMatchBufferSize();
                }

                @Override
                public int matchPlainHeader(ByteBuffer buffer) {
                    Object[] match_data = UDPConnectionManager.this.incoming_manager.checkForMatch(helper, local_port, buffer, true);
                    if (match_data == null) {
                        return 1;
                    }
                    return 2;
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            helper.close(Debug.getNestedExceptionMessage(e));
        }
    }

    protected synchronized int allocationConnectionID() {
        int id;
        if ((id = this.next_connection_id++) < 0) {
            id = 0;
            this.next_connection_id = 1;
        }
        return id;
    }

    protected void timeoutDeadKeys() {
        Iterator it = this.recently_dead_keys.values().iterator();
        long now = SystemTime.getCurrentTime();
        while (it.hasNext()) {
            long dead_time = (Long)it.next();
            if (dead_time <= now && now - dead_time <= 30000L) continue;
            it.remove();
        }
    }

    protected void logStats() {
        if (Logger.isEnabled()) {
            long[] nw_stats = this.network_glue.getStats();
            String str = "UDPConnection stats: sent=" + nw_stats[0] + "/" + nw_stats[1] + ",received=" + nw_stats[2] + "/" + nw_stats[3];
            str = String.valueOf(str) + ", setup discards=" + this.setup_discard_packets + "/" + this.setup_discard_bytes;
            str = String.valueOf(str) + ", rate discards=" + this.rate_limit_discard_packets + "/" + this.rate_limit_discard_bytes;
            Logger.log(new LogEvent(LOGID, str));
        }
    }

    protected boolean trace() {
        return LOG;
    }

    protected void trace(String str) {
        if (LOG && Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, str));
        }
    }

    protected class ProtocolTimer {
        private volatile boolean destroyed;

        protected ProtocolTimer() {
            new AEThread2("UDPConnectionManager:timer", true){
                private int tick_count;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread.currentThread().setPriority(6);
                    while (!ProtocolTimer.this.destroyed) {
                        try {
                            Thread.sleep(25L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++this.tick_count;
                        if (this.tick_count % 2400 == 0) {
                            UDPConnectionManager.this.logStats();
                        }
                        ArrayList<Object[]> failed_sets = null;
                        Map map = UDPConnectionManager.this.connection_sets;
                        synchronized (map) {
                            int cs_size = UDPConnectionManager.this.connection_sets.size();
                            UDPConnectionManager.this.checkThreadDeath(cs_size > 0);
                            if (cs_size > 0) {
                                Iterator it = UDPConnectionManager.this.connection_sets.values().iterator();
                                while (it.hasNext()) {
                                    UDPConnectionSet set = (UDPConnectionSet)it.next();
                                    try {
                                        set.timerTick();
                                        if (!set.idleLimitExceeded()) continue;
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(LOGID, "Idle limit exceeded for " + set.getName() + ", removing"));
                                        }
                                        UDPConnectionManager.this.recently_dead_keys.put(set.getKey(), new Long(SystemTime.getCurrentTime()));
                                        it.remove();
                                        set.removed();
                                    }
                                    catch (Throwable e) {
                                        if (failed_sets == null) {
                                            failed_sets = new ArrayList<Object[]>();
                                        }
                                        failed_sets.add(new Object[]{set, e});
                                    }
                                }
                            }
                        }
                        if (failed_sets == null) continue;
                        int i = 0;
                        while (i < failed_sets.size()) {
                            Object[] entry = (Object[])failed_sets.get(i);
                            ((UDPConnectionSet)entry[0]).failed((Throwable)entry[1]);
                            ++i;
                        }
                    }
                    UDPConnectionManager.this.logStats();
                }
            }.start();
        }

        protected void destroy() {
            this.destroyed = true;
        }
    }
}

