/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.utp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointHandler;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPTransport;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AddressUtils;

public class ProtocolEndpointUTP
implements ProtocolEndpoint {
    private static UTPConnectionManager manager;
    private ConnectionEndpoint ce;
    private InetSocketAddress address;

    public static void register(UTPConnectionManager _manager) {
        manager = _manager;
        ProtocolEndpointFactory.registerHandler(new ProtocolEndpointHandler(){

            @Override
            public int getType() {
                return 3;
            }

            @Override
            public ProtocolEndpoint create(InetSocketAddress address) {
                return new ProtocolEndpointUTP(address, null);
            }

            @Override
            public ProtocolEndpoint create(ConnectionEndpoint connection_endpoint, InetSocketAddress address) {
                return new ProtocolEndpointUTP(connection_endpoint, address, null);
            }
        });
    }

    private ProtocolEndpointUTP(ConnectionEndpoint _ce, InetSocketAddress _address) {
        this.ce = _ce;
        this.address = _address;
        this.ce.addProtocol(this);
    }

    private ProtocolEndpointUTP(InetSocketAddress _address) {
        this.ce = new ConnectionEndpoint(_address);
        this.address = _address;
        this.ce.addProtocol(this);
    }

    @Override
    public void setConnectionEndpoint(ConnectionEndpoint _ce) {
        this.ce = _ce;
        this.ce.addProtocol(this);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public InetSocketAddress getAdjustedAddress(boolean to_lan) {
        return AddressUtils.adjustTCPAddress(this.address, to_lan);
    }

    @Override
    public ConnectionEndpoint getConnectionEndpoint() {
        return this.ce;
    }

    @Override
    public Transport connectOutbound(boolean connect_with_crypto, boolean allow_fallback, byte[][] shared_secrets, ByteBuffer initial_data, int priority, Transport.ConnectListener listener) {
        UTPTransport t = new UTPTransport(manager, this, connect_with_crypto, allow_fallback, shared_secrets);
        t.connectOutbound(initial_data, listener, priority);
        return t;
    }

    @Override
    public String getDescription() {
        return this.address.toString();
    }

    /* synthetic */ ProtocolEndpointUTP(InetSocketAddress inetSocketAddress, ProtocolEndpointUTP protocolEndpointUTP) {
        this(inetSocketAddress);
    }

    /* synthetic */ ProtocolEndpointUTP(ConnectionEndpoint connectionEndpoint, InetSocketAddress inetSocketAddress, ProtocolEndpointUTP protocolEndpointUTP) {
        this(connectionEndpoint, inetSocketAddress);
    }
}

