/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.utp;

import com.aelitis.azureus.core.networkmanager.impl.utp.UTPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPSelector;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPTransportHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;

public class UTPConnection {
    private UTPConnectionManager manager;
    private long utp_socket;
    private InetSocketAddress remote_address;
    private long con_id;
    private UTPTransportHelper transport;
    private List<ByteBuffer> read_buffers = new LinkedList<ByteBuffer>();
    private volatile boolean connected = true;
    private boolean is_incoming;
    private volatile boolean is_writable;
    private volatile boolean is_unusable;
    private long total_received;
    private long total_sent;
    private int last_read_buff = -1;
    private int last_read = -1;
    private int last_write_buff = -1;
    private int last_write = -1;
    private long close_time;

    protected UTPConnection(UTPConnectionManager _manager, InetSocketAddress _remote_address, UTPTransportHelper _transport, long _utp_socket, long _con_id) {
        this.manager = _manager;
        this.remote_address = _remote_address;
        this.transport = _transport;
        this.utp_socket = _utp_socket;
        this.con_id = _con_id;
        if (this.transport == null) {
            this.is_writable = true;
            this.is_incoming = true;
        }
    }

    protected InetSocketAddress getRemoteAddress() {
        return this.remote_address;
    }

    protected long getSocket() {
        return this.utp_socket;
    }

    protected long getConnectionID() {
        return this.con_id;
    }

    protected UTPSelector getSelector() {
        return this.manager.getSelector();
    }

    public boolean isIncoming() {
        return this.is_incoming;
    }

    protected void setTransport(UTPTransportHelper _transport) {
        this.transport = _transport;
    }

    protected UTPTransportHelper getTransport() {
        return this.transport;
    }

    protected void setConnected() {
        if (this.transport != null) {
            this.transport.setConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(ByteBuffer data) throws IOException {
        int rem = data.remaining();
        this.total_received += (long)rem;
        if (rem < 256) {
            byte[] temp = new byte[rem];
            data.get(temp);
            data = ByteBuffer.wrap(temp);
        }
        if (!this.connected) {
            throw new IOException("Transport closed");
        }
        boolean was_empty = false;
        List<ByteBuffer> list = this.read_buffers;
        synchronized (list) {
            was_empty = this.read_buffers.size() == 0;
            this.read_buffers.add(data);
        }
        if (was_empty) {
            this.transport.canRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getReceivePendingSize() {
        List<ByteBuffer> list = this.read_buffers;
        synchronized (list) {
            int res = 0;
            for (ByteBuffer b : this.read_buffers) {
                res += b.remaining();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canRead() {
        List<ByteBuffer> list = this.read_buffers;
        synchronized (list) {
            return this.read_buffers.size() > 0;
        }
    }

    protected void setCanWrite(boolean b) {
        if (this.is_writable != b) {
            this.is_writable = b;
            if (this.is_writable) {
                this.transport.canWrite();
            }
        }
    }

    protected boolean canWrite() {
        return this.is_writable;
    }

    protected int write(ByteBuffer[] buffers, int offset, int length) throws IOException {
        int max = 0;
        int i = offset;
        while (i < offset + length) {
            max += buffers[i].remaining();
            ++i;
        }
        this.last_write_buff = max;
        if (!this.is_writable) {
            this.last_write = 0;
            return 0;
        }
        int written = this.manager.write(this, buffers, offset, length);
        this.total_sent += (long)written;
        this.last_write = written;
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(ByteBuffer buffer) throws IOException {
        int total = 0;
        boolean drained = false;
        this.last_read_buff = buffer.remaining();
        List<ByteBuffer> list = this.read_buffers;
        synchronized (list) {
            while (this.read_buffers.size() > 0) {
                int rem = buffer.remaining();
                if (rem == 0) break;
                ByteBuffer b = this.read_buffers.get(0);
                int old_limit = b.limit();
                if (b.remaining() > rem) {
                    b.limit(b.position() + rem);
                }
                buffer.put(b);
                b.limit(old_limit);
                total += rem - buffer.remaining();
                if (b.hasRemaining()) break;
                this.read_buffers.remove(0);
            }
            drained = this.read_buffers.size() == 0;
        }
        if (drained) {
            this.manager.readBufferDrained(this);
        }
        this.last_read = total;
        return total;
    }

    protected void close(String reason) {
        if (this.transport != null) {
            this.transport.close(reason);
        } else {
            this.closeSupport(reason);
        }
    }

    protected void closeSupport(String reason) {
        this.connected = false;
        this.manager.close(this, reason);
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected void setUnusable() {
        if (!this.is_unusable) {
            this.is_unusable = true;
            this.close_time = SystemTime.getMonotonousTime();
        }
    }

    protected boolean isUnusable() {
        return this.is_unusable;
    }

    protected long getCloseTime() {
        return this.close_time;
    }

    protected void poll() {
        if (this.transport != null) {
            this.transport.poll();
        }
    }

    protected String getState() {
        return "sent=" + DisplayFormatters.formatByteCountToKiBEtc(this.total_sent) + ", received=" + DisplayFormatters.formatByteCountToKiBEtc(this.total_received) + ", writable=" + this.is_writable + ", last_w_buff=" + this.last_write_buff + ", last_w=" + this.last_write + ", last_r_buff=" + this.last_read_buff + ", last_r=" + this.last_read + ", read_pend=" + this.getReceivePendingSize();
    }

    public String getString() {
        return this.remote_address + ", socket=" + this.utp_socket + ", con_id" + this.con_id + " - " + this.getState();
    }
}

