/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnpmediaserver;

import com.aelitis.azureus.core.content.AzureusContent;
import com.aelitis.azureus.core.content.AzureusContentDirectory;
import com.aelitis.azureus.core.content.AzureusContentDownload;
import com.aelitis.azureus.core.content.AzureusContentFile;
import com.aelitis.azureus.core.content.AzureusContentFilter;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;

public class UPnPMediaServerContentDirectory {
    public static final int CT_UNKNOWN = -1;
    public static final int CT_DEFAULT = 1;
    public static final int CT_XBOX = 2;
    public static final int CT_MEDIA_PLAYER = 3;
    private static final String CONTENT_UNKNOWN = "object.item";
    protected static final String CONTENT_CONTAINER = "object.container.storageFolder";
    protected static final String CONTENT_VIDEO = "object.item.videoItem.movie";
    protected static final String CONTENT_AUDIO = "object.item.audioItem.musicTrack";
    protected static final String CONTENT_IMAGE = "object.item.imageItem.photo";
    private static final String XBOX_CONTENT_VIDEO = "object.item.videoItem";
    private static final String XBOX_CONTENT_AUDIO = "object.item.audioItem.musicTrack";
    private static final String XBOX_CONTENT_IMAGE = "object.item.imageItem.photo";
    private static final String[][] mime_mappings = new String[][]{{"asf", "video/x-ms-asf", "object.item.videoItem.movie"}, {"asx", "video/x-ms-asf", "object.item.videoItem.movie"}, {"nsc", "video/x-ms-asf", "object.item.videoItem.movie"}, {"wax", "audio/x-ms-wax", "object.item.audioItem.musicTrack"}, {"wm", "video/x-ms-wm", "object.item.videoItem.movie"}, {"wma", "audio/x-ms-wma", "object.item.audioItem.musicTrack"}, {"wmv", "video/x-ms-wmv", "object.item.videoItem.movie"}, {"wmx", "video/x-ms-wmx", "object.item.videoItem.movie"}, {"wvx", "video/x-ms-wvx", "object.item.videoItem.movie"}, {"avi", "video/avi", "object.item.videoItem.movie"}, {"mp2", "video/mpeg", "object.item.videoItem.movie"}, {"mpa", "video/mpeg", "object.item.videoItem.movie"}, {"mpe", "video/mpeg", "object.item.videoItem.movie"}, {"mpeg", "video/mpeg", "object.item.videoItem.movie"}, {"mpg", "video/mpeg", "object.item.videoItem.movie"}, {"mpv2", "video/mpeg", "object.item.videoItem.movie"}, {"vob", "video/mpeg", "object.item.videoItem.movie"}, {"mov", "video/quicktime", "object.item.videoItem.movie"}, {"qt", "video/quicktime", "object.item.videoItem.movie"}, {"lsf", "video/x-la-asf", "object.item.videoItem.movie"}, {"lsx", "video/x-la-asf", "object.item.videoItem.movie"}, {"movie", "video/x-sgi-movie", "object.item.videoItem.movie"}, {"mkv", "video/x-matroska", "video/x-mkv", "object.item.videoItem.movie"}, {"mp4", "video/mp4", "object.item.videoItem.movie"}, {"mpg4", "video/mp4", "object.item.videoItem.movie"}, {"flv", "video/x-flv", "object.item.videoItem.movie"}, {"ts", "video/MP2T", "object.item.videoItem.movie"}, {"m4v", "video/m4v", "video/mp4", "object.item.videoItem.movie"}, {"mts", "video/MP2T", "object.item.videoItem.movie"}, {"m2ts", "video/MP2T", "object.item.videoItem.movie"}, {"au", "audio/basic", "object.item.audioItem.musicTrack"}, {"snd", "audio/basic", "object.item.audioItem.musicTrack"}, {"mid", "audio/mid", "object.item.audioItem.musicTrack"}, {"rmi", "audio/mid", "object.item.audioItem.musicTrack"}, {"mp3", "audio/mpeg", "object.item.audioItem.musicTrack"}, {"aif", "audio/x-aiff", "object.item.audioItem.musicTrack"}, {"aifc", "audio/x-aiff", "object.item.audioItem.musicTrack"}, {"aiff", "audio/x-aiff", "object.item.audioItem.musicTrack"}, {"m3u", "audio/x-mpegurl", "object.item.audioItem.musicTrack"}, {"ra", "audio/x-pn-realaudio", "object.item.audioItem.musicTrack"}, {"ram", "audio/x-pn-realaudio", "object.item.audioItem.musicTrack"}, {"wav", "audio/x-wav", "object.item.audioItem.musicTrack"}, {"flac", "audio/flac", "object.item.audioItem.musicTrack"}, {"mka", "audio/x-matroska", "object.item.audioItem.musicTrack"}, {"m4a", "audio/mp4", "object.item.audioItem.musicTrack"}, {"bmp", "image/bmp", "object.item.imageItem.photo"}, {"cod", "image/cis-cod", "object.item.imageItem.photo"}, {"gif", "image/gif", "object.item.imageItem.photo"}, {"ief", "image/ief", "object.item.imageItem.photo"}, {"jpe", "image/jpeg", "object.item.imageItem.photo"}, {"jpeg", "image/jpeg", "object.item.imageItem.photo"}, {"jpg", "image/jpeg", "object.item.imageItem.photo"}, {"png", "image/png", "object.item.imageItem.photo"}, {"jfif", "image/pipeg", "object.item.imageItem.photo"}, {"tif", "image/tiff", "object.item.imageItem.photo"}, {"tiff", "image/tiff", "object.item.imageItem.photo"}, {"ras", "image/x-cmu-raster", "object.item.imageItem.photo"}, {"cmx", "image/x-cmx", "object.item.imageItem.photo"}, {"ico", "image/x-icon", "object.item.imageItem.photo"}, {"pnm", "image/x-portable-anymap", "object.item.imageItem.photo"}, {"pbm", "image/x-portable-bitmap", "object.item.imageItem.photo"}, {"pgm", "image/x-portable-graymap", "object.item.imageItem.photo"}, {"ppm", "image/x-portable-pixmap", "object.item.imageItem.photo"}, {"rgb", "image/x-rgb", "object.item.imageItem.photo"}, {"xbm", "image/x-xbitmap", "object.item.imageItem.photo"}, {"xpm", "image/x-xpixmap", "object.item.imageItem.photo"}, {"xwd", "image/x-xwindowdump", "object.item.imageItem.photo"}, {"ogg", "application/ogg", "object.item.audioItem.musicTrack"}, {"ogm", "application/ogg", "object.item.videoItem.movie"}};
    private static Map<String, String[]> ext_lookup_map = new HashMap<String, String[]>();
    private static SimpleDateFormat upnp_date_format;
    private UPnPMediaServer media_server;
    private TorrentAttribute ta_unique_name;
    private int next_oid;
    private Random random = new Random();
    private int system_update_id = this.random.nextInt(Integer.MAX_VALUE);
    private Map<Integer, content> content_map = new HashMap<Integer, content>();
    private Map<String, Long> config;
    private boolean config_dirty;
    private Object lock = new Object();
    private contentContainer root_container;
    private contentContainer downloads_container;
    private contentContainer movies_container;
    private contentContainer music_container;
    private contentContainer pictures_container;
    private Map<HashWrapper, String> unique_name_map = new HashMap<HashWrapper, String>();
    private Set<String> unique_names = new HashSet<String>();

    static {
        int i = 0;
        while (i < mime_mappings.length) {
            ext_lookup_map.put(mime_mappings[i][0], mime_mappings[i]);
            ++i;
        }
        upnp_date_format = new SimpleDateFormat("yyyy-MM-dd");
    }

    protected UPnPMediaServerContentDirectory(UPnPMediaServer _media_server) {
        this.media_server = _media_server;
        this.ta_unique_name = this.media_server.getPluginInterface().getTorrentManager().getPluginAttribute("unique_name");
        this.root_container = new contentContainer(null, "Vuze");
        this.music_container = new contentContainer(this.root_container, "Music", "M");
        this.pictures_container = new contentContainer(this.root_container, "Pictures", "P");
        this.movies_container = new contentContainer(this.root_container, "Movies", "V");
        this.downloads_container = new contentContainer(this.root_container, "Downloads");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContent(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        HashWrapper hash = new HashWrapper(torrent.getHash());
        DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
        Object object = this.lock;
        synchronized (object) {
            if (files.length == 1) {
                String title = this.getUniqueName(download, hash, files[0].getFile().getName());
                contentItem item = new contentItem(this.downloads_container, this.getACF(files[0]), download.getTorrent().getHash(), title);
                this.addToFilters(item);
            } else {
                String title;
                DiskManagerFileInfo file;
                contentContainer container = new contentContainer(this.downloads_container, this.getACD(download), this.getUniqueName(download, hash, download.getName()));
                HashSet<String> name_set = new HashSet<String>();
                boolean duplicate = false;
                int j = 0;
                while (j < files.length) {
                    file = files[j];
                    title = file.getFile().getName();
                    if (name_set.contains(title)) {
                        duplicate = true;
                        break;
                    }
                    name_set.add(title);
                    ++j;
                }
                j = 0;
                while (j < files.length) {
                    file = files[j];
                    title = file.getFile().getName();
                    if (duplicate) {
                        title = String.valueOf(j + 1) + ". " + title;
                    }
                    new contentItem(container, this.getACF(file), hash.getBytes(), title);
                    ++j;
                }
                this.addToFilters(container);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContent(AzureusContentFile content_file) {
        Object object = this.lock;
        synchronized (object) {
            DiskManagerFileInfo file = content_file.getFile();
            try {
                byte[] hash = file.getDownloadHash();
                Object otitle = content_file.getProperty("title");
                String title = otitle instanceof String ? this.getUniqueName(null, null, (String)otitle) : this.getUniqueName(null, new HashWrapper(hash), file.getFile().getName());
                contentItem item = new contentItem(this.downloads_container, content_file, hash, title);
                this.addToFilters(item);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void removeContent(AzureusContentFile file) {
        this.removeContent(file.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContent(DiskManagerFileInfo file) {
        Object object = this.lock;
        synchronized (object) {
            try {
                byte[] hash = file.getDownloadHash();
                String unique_name = this.getUniqueName(null, new HashWrapper(hash), file.getFile().getName());
                content container = this.downloads_container.removeChild(unique_name);
                this.removeUniqueName(new HashWrapper(hash));
                if (container != null) {
                    this.removeFromFilters(container);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContent(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        HashWrapper hash = new HashWrapper(torrent.getHash());
        DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
        Object object = this.lock;
        synchronized (object) {
            String unique_name = files.length == 1 ? this.getUniqueName(download, hash, files[0].getFile().getName()) : this.getUniqueName(download, hash, download.getName());
            content container = this.downloads_container.removeChild(unique_name);
            this.removeUniqueName(hash);
            if (container != null) {
                this.removeFromFilters(container);
            }
        }
    }

    protected void invalidate() {
        this.root_container.invalidate();
    }

    private String findPrimaryContentType(content con) {
        if (con instanceof contentItem) {
            return ((contentItem)con).getContentClass();
        }
        String type = CONTENT_UNKNOWN;
        contentContainer container = (contentContainer)con;
        List<content> kids = container.getChildren();
        int i = 0;
        while (i < kids.size()) {
            String t = this.findPrimaryContentType(kids.get(i));
            if (t == CONTENT_VIDEO) {
                return t;
            }
            if (t == "object.item.audioItem.musicTrack") {
                type = t;
            } else if (t == "object.item.imageItem.photo" && type == CONTENT_UNKNOWN) {
                type = t;
            }
            ++i;
        }
        return type;
    }

    private void addToFilters(content con) {
        String type = this.findPrimaryContentType(con);
        if (this.media_server.useCategories() || this.media_server.useTags()) {
            String[] tags;
            String[] categories = this.media_server.useCategories() ? con.getCategories() : new String[]{};
            String[] stringArray = tags = this.media_server.useTags() ? con.getTags() : new String[]{};
            if (categories.length == 0 && tags.length == 0) {
                if (type == CONTENT_VIDEO) {
                    this.movies_container.addLink(con);
                } else if (type == "object.item.audioItem.musicTrack") {
                    this.music_container.addLink(con);
                } else if (type == "object.item.imageItem.photo") {
                    this.pictures_container.addLink(con);
                }
            } else {
                String[][] stringArrayArray = new String[][]{categories, tags};
                int n = stringArrayArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] entry;
                    String[] stringArray2 = entry = stringArrayArray[n2];
                    int n3 = entry.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String cat_or_tag = stringArray2[n4];
                        contentContainer parent = null;
                        if (type == CONTENT_VIDEO) {
                            parent = this.movies_container;
                        } else if (type == "object.item.audioItem.musicTrack") {
                            parent = this.music_container;
                        } else if (type == "object.item.imageItem.photo") {
                            parent = this.pictures_container;
                        }
                        if (parent != null) {
                            content node = null;
                            int num = 0;
                            while (!(node instanceof contentContainer) || ((contentContainer)node).getACD() != null) {
                                String name;
                                if ((node = parent.getChild(name = num++ == 0 ? cat_or_tag : String.valueOf(num) + ". " + cat_or_tag)) != null) continue;
                                node = new contentContainer(parent, name);
                            }
                            ((contentContainer)node).addLink(con);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        } else if (type == CONTENT_VIDEO) {
            this.movies_container.addLink(con);
        } else if (type == "object.item.audioItem.musicTrack") {
            this.music_container.addLink(con);
        } else if (type == "object.item.imageItem.photo") {
            this.pictures_container.addLink(con);
        }
    }

    private void removeFromFilters(content con) {
        contentContainer[] parents;
        contentContainer[] contentContainerArray = parents = new contentContainer[]{this.movies_container, this.pictures_container, this.music_container};
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            contentContainer parent = contentContainerArray[n2];
            parent.removeLink(con.getName());
            if (this.media_server.useCategories() || this.media_server.useTags()) {
                List<content> kids = parent.getChildren();
                for (content k : kids) {
                    if (!(k instanceof contentContainer) || ((contentContainer)k).getACD() != null) continue;
                    ((contentContainer)k).removeLink(con.getName());
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contentChanged(AzureusContentFile acf) {
        if (this.media_server.useCategories() || this.media_server.useTags()) {
            Object object = this.lock;
            synchronized (object) {
                this.contentChanged(this.downloads_container, acf);
            }
        }
    }

    protected boolean contentChanged(contentContainer content2, AzureusContentFile acf) {
        for (content c : content2.getChildren()) {
            if (c instanceof contentItem) {
                if (((contentItem)c).getACF() != acf) continue;
                this.removeFromFilters(c);
                this.addToFilters(c);
                return true;
            }
            if (!this.contentChanged((contentContainer)c, acf)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUniqueName(Download dl, HashWrapper hw, String name) {
        Set<String> set = this.unique_names;
        synchronized (set) {
            String result;
            String string = result = hw == null ? null : this.unique_name_map.get(hw);
            if (result != null) {
                return result;
            }
            String string2 = result = dl == null ? null : dl.getAttribute(this.ta_unique_name);
            if (result == null || result.length() == 0) {
                result = name;
            }
            int num = 1;
            while (this.unique_names.contains(result)) {
                result = String.valueOf(num++) + ". " + name;
            }
            if (num > 1 && dl != null) {
                dl.setAttribute(this.ta_unique_name, result);
            }
            this.unique_names.add(result);
            if (hw != null) {
                this.unique_name_map.put(hw, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUniqueName(HashWrapper hash) {
        Set<String> set = this.unique_names;
        synchronized (set) {
            String name = this.unique_name_map.remove(hash);
            if (name != null) {
                this.unique_names.remove(name);
            }
        }
    }

    protected void ensureStarted() {
        this.media_server.ensureStarted();
    }

    protected contentContainer getRootContainer() {
        this.ensureStarted();
        return this.root_container;
    }

    protected contentContainer getMoviesContainer() {
        this.ensureStarted();
        return this.movies_container;
    }

    protected contentContainer getMusicContainer() {
        this.ensureStarted();
        return this.music_container;
    }

    protected contentContainer getPicturesContainer() {
        this.ensureStarted();
        return this.pictures_container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected content getContentFromID(int id) {
        this.ensureStarted();
        Map<Integer, content> map = this.content_map;
        synchronized (map) {
            return this.content_map.get(new Integer(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected contentContainer getContainerFromID(int id) {
        this.ensureStarted();
        Map<Integer, content> map = this.content_map;
        synchronized (map) {
            content c = this.content_map.get(new Integer(id));
            if (c instanceof contentContainer) {
                return (contentContainer)c;
            }
        }
        return null;
    }

    protected contentItem peekContentFromResourceID(String id) {
        return this.getContentFromResourceIDSupport(id, true);
    }

    protected contentItem getContentFromResourceID(String id) {
        return this.getContentFromResourceIDSupport(id, false);
    }

    protected contentItem getContentFromResourceIDSupport(String id, boolean is_peek) {
        int pos;
        if (!is_peek) {
            this.ensureStarted();
        }
        if ((pos = id.indexOf("-")) == -1) {
            this.log("Failed to decode resource id '" + id + "'");
            return null;
        }
        byte[] hash = ByteFormatter.decodeString(id.substring(0, pos));
        String rem = id.substring(pos + 1);
        if ((pos = rem.indexOf(".")) != -1) {
            rem = rem.substring(0, pos);
        }
        try {
            int file_index = Integer.parseInt(rem);
            return this.getExistingContentFromHashAndFileIndex(hash, file_index);
        }
        catch (Throwable e) {
            this.log("Failed to decode resource id '" + id + "'", e);
            return null;
        }
    }

    protected contentItem getContentFromHash(byte[] hash) {
        this.ensureStarted();
        contentItem item = this.getExistingContentFromHash(hash);
        if (item == null) {
            AzureusContentDirectory[] directories = this.media_server.getAzureusContentDirectories();
            HashMap<String, byte[]> lookup = new HashMap<String, byte[]>();
            lookup.put("btih", hash);
            int i = 0;
            block2: while (i < directories.length) {
                Torrent torrent;
                AzureusContentDirectory directory = directories[i];
                AzureusContent content2 = directory.lookupContent(lookup);
                if (content2 != null && (torrent = content2.getTorrent()) != null) {
                    DownloadManager dm = this.media_server.getPluginInterface().getDownloadManager();
                    dm.pauseDownloads();
                    try {
                        Download download = dm.addDownload(torrent);
                        this.addContent(download);
                        item = this.getExistingContentFromHash(hash);
                        int sleep = 100;
                        int max = 20000;
                        int j = 0;
                        while (j < max / sleep) {
                            int state = download.getState();
                            if (state == 4 || state == 5 || state == 8 || state == 7) break block2;
                            Thread.sleep(sleep);
                            ++j;
                        }
                        break;
                    }
                    catch (Throwable e) {
                        this.log("Failed to add download", e);
                    }
                }
                ++i;
            }
        }
        return item;
    }

    protected AzureusContentFile getACF(final DiskManagerFileInfo file) {
        try {
            byte[] hash = file.getDownloadHash();
            AzureusContentDirectory[] directories = this.media_server.getAzureusContentDirectories();
            HashMap<String, Object> lookup = new HashMap<String, Object>();
            lookup.put("btih", hash);
            lookup.put("file_index", new Integer(file.getIndex()));
            int i = 0;
            while (i < directories.length) {
                AzureusContentDirectory directory = directories[i];
                AzureusContentFile acf = directory.lookupContentFile(lookup);
                if (acf != null) {
                    return acf;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return new AzureusContentFile(){

            @Override
            public DiskManagerFileInfo getFile() {
                return file;
            }

            @Override
            public Object getProperty(String name) {
                return null;
            }
        };
    }

    protected AzureusContentDownload getACD(final Download download) {
        try {
            byte[] hash = download.getTorrent().getHash();
            AzureusContentDirectory[] directories = this.media_server.getAzureusContentDirectories();
            HashMap<String, byte[]> lookup = new HashMap<String, byte[]>();
            lookup.put("btih", hash);
            int i = 0;
            while (i < directories.length) {
                AzureusContentDirectory directory = directories[i];
                AzureusContentDownload acf = directory.lookupContentDownload(lookup);
                if (acf != null) {
                    return acf;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return new AzureusContentDownload(){

            @Override
            public Download getDownload() {
                return download;
            }

            @Override
            public Object getProperty(String name) {
                return null;
            }
        };
    }

    protected contentItem getExistingContentFromHash(byte[] hash) {
        this.ensureStarted();
        return this.getExistingContentFromHashAndFileIndex(hash, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected contentItem getExistingContentFromHashAndFileIndex(byte[] hash, int file_index) {
        this.ensureStarted();
        Map<Integer, content> map = this.content_map;
        synchronized (map) {
            for (content content2 : this.content_map.values()) {
                contentItem item;
                DiskManagerFileInfo file;
                if (!(content2 instanceof contentItem) || (file = (item = (contentItem)content2).getFile()).getIndex() != file_index || !Arrays.equals(item.getHash(), hash)) continue;
                return item;
            }
        }
        return null;
    }

    protected String getDIDL(content con, String host, int client_type, List<AzureusContentFilter> filters, Map<String, Object> filter_args) {
        if (con instanceof contentContainer) {
            long storage_used;
            int child_count;
            contentContainer child_container = (contentContainer)con;
            List<content> kids = child_container.getChildren();
            if (filters.size() == 0) {
                child_count = kids.size();
                storage_used = child_container.getStorageUsed();
            } else {
                child_count = 0;
                storage_used = 0L;
                for (content kid : kids) {
                    if (!this.media_server.isVisible(kid, filters, filter_args)) continue;
                    ++child_count;
                    storage_used += kid.getStorageUsed();
                }
            }
            String didl = "<container id=\"" + child_container.getID() + "\" parentID=\"" + child_container.getParentID() + "\" childCount=\"" + child_count + "\" restricted=\"false\" searchable=\"true\">" + "<dc:title>" + this.escapeXML(child_container.getName()) + "</dc:title>" + "<upnp:class>" + CONTENT_CONTAINER + "</upnp:class>" + "<upnp:storageUsed>" + storage_used + "</upnp:storageUsed>" + "<upnp:writeStatus>WRITABLE</upnp:writeStatus>";
            if (child_container.mediaClass != null) {
                didl = String.valueOf(didl) + "<av:mediaClass xmlns:av=\"urn:schemas-sony-com:av\">" + child_container.mediaClass + "</av:mediaClass>";
            }
            didl = String.valueOf(didl) + "</container>";
            return didl;
        }
        contentItem child_item = (contentItem)con;
        return "<item id=\"" + child_item.getID() + "\" parentID=\"" + child_item.getParentID() + "\" restricted=\"false\">" + child_item.getDIDL(host, client_type) + "</item>";
    }

    protected String createResourceID(byte[] hash, DiskManagerFileInfo file) {
        String res = String.valueOf(ByteFormatter.encodeString(hash)) + "-" + file.getIndex();
        String name = file.getFile().toString();
        int pos = name.lastIndexOf(46);
        if (pos != -1 && !name.endsWith(".")) {
            res = String.valueOf(res) + name.substring(pos);
        }
        return res;
    }

    protected int getSystemUpdateID() {
        return this.system_update_id;
    }

    protected String escapeXML(String str) {
        return this.media_server.escapeXML(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPersistentContainerID(String name) {
        Object object = this.lock;
        synchronized (object) {
            Long res = this.readConfig().get(name);
            if (res != null) {
                return res.intValue();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistentContainerIDAdded() {
        Object object = this.lock;
        synchronized (object) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("UPnPMS:CD:dirty", 10000L, new AERunnable(){

                @Override
                public void runSupport() {
                    UPnPMediaServerContentDirectory.this.writeConfig();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Long> readConfig() {
        Object object = this.lock;
        synchronized (object) {
            if (this.config != null) {
                return this.config;
            }
            File file = this.media_server.getPluginInterface().getPluginconfig().getPluginUserFile("cd.dat");
            Map map = FileUtil.readResilientFile(file);
            Map id_map2 = (Map)map.get("id_map2");
            if (id_map2 != null) {
                this.config = new HashMap<String, Long>();
                try {
                    for (Map.Entry entry : id_map2.entrySet()) {
                        this.config.put(new String(Base32.decode((String)entry.getKey()), "UTF-8"), (Long)entry.getValue());
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            } else {
                this.config = (Map)map.get("id_map");
            }
            if (this.config == null) {
                this.config = new HashMap<String, Long>();
            }
            new DelayedEvent("UPnPMS:CD:dirty", 30000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    Object object = UPnPMediaServerContentDirectory.this.lock;
                    synchronized (object) {
                        UPnPMediaServerContentDirectory.this.config = null;
                    }
                }
            });
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeConfig() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.config_dirty) {
                return;
            }
            File file = this.media_server.getPluginInterface().getPluginconfig().getPluginUserFile("cd.dat");
            HashMap map = new HashMap();
            HashMap<String, Long> old_id_map = new HashMap<String, Long>();
            this.addPersistentContainerIDs(old_id_map, this.root_container);
            try {
                HashMap<String, Long> id_map2 = new HashMap<String, Long>();
                for (Map.Entry entry : old_id_map.entrySet()) {
                    id_map2.put(Base32.encode(((String)entry.getKey()).getBytes("UTF-8")), (Long)entry.getValue());
                }
                map.put("id_map2", id_map2);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            FileUtil.writeResilientFile(file, map);
            this.config_dirty = false;
        }
    }

    protected void addPersistentContainerIDs(Map<String, Long> map, contentContainer container) {
        String full_name = container.getFullName(container.getName());
        map.put(full_name, new Long(container.getID()));
        List<content> kids = container.getChildren();
        for (content kid : kids) {
            if (!(kid instanceof contentContainer)) continue;
            this.addPersistentContainerIDs(map, (contentContainer)kid);
        }
    }

    protected void destroy() {
        this.writeConfig();
    }

    protected void print() {
        this.root_container.print("");
    }

    protected void log(String str) {
        this.media_server.log(str);
    }

    protected void log(String str, Throwable e) {
        this.media_server.log(str, e);
    }

    protected abstract class content
    implements Cloneable {
        private int id;
        private contentContainer parent;

        protected content(contentContainer _parent) {
            this(_parent, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected content(contentContainer _parent, String _name) {
            this.parent = _parent;
            int existing_oid = -1;
            if (_name != null) {
                String full_name = this.getFullName(_name);
                existing_oid = UPnPMediaServerContentDirectory.this.getPersistentContainerID(full_name);
            }
            Map map = UPnPMediaServerContentDirectory.this.content_map;
            synchronized (map) {
                if (UPnPMediaServerContentDirectory.this.next_oid == 0) {
                    this.id = 0;
                    UPnPMediaServerContentDirectory.this.next_oid = (int)(SystemTime.getCurrentTime() / 1000L);
                } else if (existing_oid != -1) {
                    this.id = existing_oid;
                } else {
                    UPnPMediaServerContentDirectory uPnPMediaServerContentDirectory2 = UPnPMediaServerContentDirectory.this;
                    int n = uPnPMediaServerContentDirectory2.next_oid;
                    uPnPMediaServerContentDirectory2.next_oid = n + 1;
                    this.id = n;
                }
                Integer i_id = new Integer(this.id);
                while (UPnPMediaServerContentDirectory.this.content_map.containsKey(i_id)) {
                    UPnPMediaServerContentDirectory uPnPMediaServerContentDirectory3 = UPnPMediaServerContentDirectory.this;
                    uPnPMediaServerContentDirectory3.next_oid = uPnPMediaServerContentDirectory3.next_oid + 1;
                    this.id = this.id;
                    i_id = this.id;
                    existing_oid = -1;
                }
                UPnPMediaServerContentDirectory.this.content_map.put(i_id, this);
            }
            if (_name != null && existing_oid == -1) {
                UPnPMediaServerContentDirectory.this.persistentContainerIDAdded();
            }
        }

        protected int getID() {
            return this.id;
        }

        protected String getFullName(String name) {
            String full_name = name;
            contentContainer current = this.parent;
            while (current != null) {
                full_name = String.valueOf(current.getName()) + "::" + full_name;
                current = current.getParent();
            }
            return full_name;
        }

        protected int getParentID() {
            if (this.parent == null) {
                return -1;
            }
            return this.parent.getID();
        }

        protected contentContainer getParent() {
            return this.parent;
        }

        protected abstract content getCopy(contentContainer var1);

        protected abstract String getName();

        protected abstract String getContentClass();

        protected abstract long getDateMillis();

        protected abstract String[] getCategories();

        protected abstract String[] getTags();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleted(boolean is_link) {
            if (!is_link) {
                Map map = UPnPMediaServerContentDirectory.this.content_map;
                synchronized (map) {
                    if (UPnPMediaServerContentDirectory.this.content_map.remove(new Integer(this.id)) == null) {
                        Debug.out("Content item with id " + this.id + " not found");
                    }
                }
            }
        }

        protected void invalidate() {
        }

        protected abstract long getStorageUsed();

        protected abstract void print(String var1);
    }

    protected class contentContainer
    extends content {
        private AzureusContentDownload download;
        private String name;
        private List<content> children;
        private int update_id;
        private String mediaClass;

        protected contentContainer(contentContainer _parent, String _name) {
            super(_parent, _name);
            this.children = new ArrayList<content>();
            this.update_id = UPnPMediaServerContentDirectory.this.random.nextInt(Integer.MAX_VALUE);
            this.name = _name;
            if (_parent != null) {
                _parent.addChildz(this);
            }
        }

        protected contentContainer(contentContainer _parent, AzureusContentDownload _download, String _name) {
            super(_parent, _name);
            this.children = new ArrayList<content>();
            this.update_id = UPnPMediaServerContentDirectory.this.random.nextInt(Integer.MAX_VALUE);
            this.download = _download;
            this.name = _name;
            if (_parent != null) {
                _parent.addChildz(this);
            }
        }

        public contentContainer(contentContainer _parent, String _name, String _mediaClass) {
            this(_parent, _name);
            this.mediaClass = _mediaClass;
        }

        protected AzureusContentDownload getACD() {
            return this.download;
        }

        @Override
        protected content getCopy(contentContainer parent) {
            contentContainer copy = new contentContainer(parent, this.download, this.name);
            int i = 0;
            while (i < this.children.size()) {
                this.children.get(i).getCopy(copy);
                ++i;
            }
            return copy;
        }

        protected void addLink(content child) {
            child.getCopy(this);
            this.updated();
        }

        protected content removeLink(String child_name) {
            Iterator<content> it = this.children.iterator();
            while (it.hasNext()) {
                content con = it.next();
                String c_name = con.getName();
                if (!c_name.equals(child_name)) continue;
                it.remove();
                this.updated();
                con.deleted(true);
                return con;
            }
            return null;
        }

        protected void addChildz(content child) {
            this.children.add(child);
            this.updated();
        }

        protected content removeChild(String child_name) {
            Iterator<content> it = this.children.iterator();
            while (it.hasNext()) {
                content con = it.next();
                String c_name = con.getName();
                if (!c_name.equals(child_name)) continue;
                it.remove();
                this.updated();
                con.deleted(false);
                return con;
            }
            UPnPMediaServerContentDirectory.this.log("    child not found");
            return null;
        }

        protected content getChild(String child_name) {
            for (content con : this.children) {
                String c_name = con.getName();
                if (!c_name.equals(child_name)) continue;
                return con;
            }
            return null;
        }

        protected void updated() {
            ++this.update_id;
            if (this.update_id < 0) {
                this.update_id = 0;
            }
            UPnPMediaServerContentDirectory.this.media_server.contentContainerUpdated(this);
            if (this.getParent() != null) {
                this.getParent().updated();
            } else {
                UPnPMediaServerContentDirectory uPnPMediaServerContentDirectory = UPnPMediaServerContentDirectory.this;
                uPnPMediaServerContentDirectory.system_update_id = uPnPMediaServerContentDirectory.system_update_id + 1;
                if (UPnPMediaServerContentDirectory.this.system_update_id < 0) {
                    UPnPMediaServerContentDirectory.this.system_update_id = 0;
                }
            }
        }

        @Override
        protected void invalidate() {
            ++this.update_id;
            if (this.update_id < 0) {
                this.update_id = 0;
            }
            UPnPMediaServerContentDirectory.this.media_server.contentContainerUpdated(this);
            if (this.getParent() == null) {
                UPnPMediaServerContentDirectory uPnPMediaServerContentDirectory = UPnPMediaServerContentDirectory.this;
                uPnPMediaServerContentDirectory.system_update_id = uPnPMediaServerContentDirectory.system_update_id + 1;
                if (UPnPMediaServerContentDirectory.this.system_update_id < 0) {
                    UPnPMediaServerContentDirectory.this.system_update_id = 0;
                }
            }
            for (content con : this.children) {
                con.invalidate();
            }
        }

        @Override
        protected void deleted(boolean is_link) {
            super.deleted(is_link);
            Iterator<content> it = this.children.iterator();
            while (it.hasNext()) {
                it.next().deleted(is_link);
            }
        }

        @Override
        protected String getName() {
            return this.name;
        }

        @Override
        protected String getContentClass() {
            return UPnPMediaServerContentDirectory.CONTENT_CONTAINER;
        }

        protected List<content> getChildren() {
            return this.children;
        }

        protected int getUpdateID() {
            return this.update_id;
        }

        @Override
        protected long getStorageUsed() {
            long res = 0L;
            for (content con : this.children) {
                res += con.getStorageUsed();
            }
            return res;
        }

        @Override
        protected long getDateMillis() {
            if (this.download == null || this.children.size() == 0) {
                return 0L;
            }
            return this.children.get(0).getDateMillis();
        }

        @Override
        protected String[] getCategories() {
            if (this.download == null || this.children.size() == 0) {
                return new String[0];
            }
            return this.children.get(0).getCategories();
        }

        @Override
        protected String[] getTags() {
            if (this.download == null || this.children.size() == 0) {
                return new String[0];
            }
            return this.children.get(0).getTags();
        }

        @Override
        protected void print(String indent) {
            UPnPMediaServerContentDirectory.this.log(String.valueOf(indent) + this.name + ", id=" + this.getID());
            indent = String.valueOf(indent) + "    ";
            for (content con : this.children) {
                con.print(indent);
            }
        }
    }

    protected class contentItem
    extends content
    implements Cloneable {
        private final AzureusContentFile content_file;
        private final byte[] hash;
        private final String title;
        private boolean valid;
        private String[] content_types;
        private String item_class;

        protected contentItem(contentContainer _parent, AzureusContentFile _content_file, byte[] _hash, String _title) {
            super(_parent);
            try {
                String[] entry;
                this.content_file = _content_file;
                this.hash = _hash;
                this.title = StringInterner.intern(_title);
                DiskManagerFileInfo file = this.content_file.getFile();
                String file_name = file.getFile().getName();
                String extension = FileUtil.getExtension(file_name);
                if (extension.length() > 1 && (entry = (String[])ext_lookup_map.get(extension.substring(1).toLowerCase(MessageText.LOCALE_ENGLISH))) != null) {
                    int num_types = entry.length - 2;
                    this.content_types = new String[num_types];
                    System.arraycopy(entry, 1, this.content_types, 0, num_types);
                    this.item_class = entry[entry.length - 1];
                    this.valid = true;
                }
                if (!this.valid) {
                    this.content_types = new String[]{"unknown/unknown"};
                    this.item_class = UPnPMediaServerContentDirectory.CONTENT_UNKNOWN;
                }
            }
            finally {
                _parent.addChildz(this);
            }
        }

        @Override
        protected content getCopy(contentContainer parent) {
            try {
                content res = (content)this.clone();
                res.parent = parent;
                parent.addChildz(res);
                return res;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        protected AzureusContentFile getACF() {
            return this.content_file;
        }

        public DiskManagerFileInfo getFile() {
            return this.content_file.getFile();
        }

        protected byte[] getHash() {
            return this.hash;
        }

        protected String getTitle() {
            return this.title;
        }

        protected String getDisplayTitle() {
            long eta;
            long percent_done;
            String t = this.getTitle();
            String str_percent = null;
            if (UPnPMediaServerContentDirectory.this.media_server.showPercentDone() && (percent_done = (long)this.getPercentDone()) >= 0L && percent_done < 1000L) {
                str_percent = DisplayFormatters.formatPercentFromThousands((int)percent_done);
            }
            String str_eta = null;
            if (UPnPMediaServerContentDirectory.this.media_server.showETA() && (eta = this.getETA()) > 0L) {
                str_eta = TimeFormatter.format(eta);
            }
            if (str_percent != null || str_eta != null) {
                t = str_percent == null ? String.valueOf(t) + " (" + str_eta + ")" : (str_eta == null ? String.valueOf(t) + " (" + str_percent + ")" : String.valueOf(t) + " (" + str_eta + " - " + str_percent + ")");
            }
            return t;
        }

        protected String getCreator() {
            return this.getStringProperty("creator", "Unknown");
        }

        protected long getSize() {
            return this.getFile().getLength();
        }

        protected long getAverageBitRate() {
            long duration = this.getDurationMillis();
            if (duration <= 0L) {
                return 0L;
            }
            long size = this.getSize();
            if (size <= 0L) {
                return 0L;
            }
            return size * 8L * 1000L / duration;
        }

        protected int getPercentDone() {
            return (int)this.getLongProperty("percent", -1L);
        }

        protected long getETA() {
            return this.getLongProperty("eta", -1L);
        }

        protected long getDurationMillis() {
            return this.getLongProperty("duration", 0L);
        }

        protected String getDuration(long def) {
            long millis = this.getLongProperty("duration", def);
            if (millis < 0L) {
                return null;
            }
            long secs = millis / 1000L;
            String result = TimeFormatter.formatColon(secs);
            String ms = String.valueOf(millis % 1000L);
            while (ms.length() < 3) {
                ms = "0" + ms;
            }
            return String.valueOf(result) + "." + ms;
        }

        protected String getResolution() {
            long width = this.getLongProperty("video_width", 0L);
            long height = this.getLongProperty("video_height", 0L);
            if (width > 0L && height > 0L) {
                return String.valueOf(width) + "x" + height;
            }
            return "640x480";
        }

        @Override
        protected long getDateMillis() {
            return this.getLongProperty("date", 0L);
        }

        protected String getDate() {
            long date_millis = this.getDateMillis();
            if (date_millis == 0L) {
                return null;
            }
            return upnp_date_format.format(new Date(date_millis));
        }

        @Override
        protected String[] getCategories() {
            try {
                String[] cats = (String[])this.content_file.getProperty("cats");
                if (cats != null) {
                    return cats;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new String[0];
        }

        @Override
        protected String[] getTags() {
            try {
                String[] tags = (String[])this.content_file.getProperty("tags");
                if (tags != null) {
                    return tags;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new String[0];
        }

        protected String getProtocolInfo(String content_type, String attributes) {
            return "http-get:*:" + content_type + ":" + attributes;
        }

        protected String getURI(String host, int stream_id) {
            return "http://" + UrlUtils.convertIPV6Host(host) + ":" + UPnPMediaServerContentDirectory.this.media_server.getContentServer().getPort() + "/Content/" + UPnPMediaServerContentDirectory.this.createResourceID(this.hash, this.getFile()) + (stream_id == -1 ? "" : "?sid=" + stream_id);
        }

        protected String getResources(String host, int client_type) {
            String res = this.getResource(host, client_type, "*");
            if (client_type != 2) {
                try {
                    String attr = null;
                    DiskManagerFileInfo file = this.content_file.getFile();
                    String file_name = file.getFile().getName();
                    String lc_fn = file_name.toLowerCase();
                    if (this.item_class.equals(UPnPMediaServerContentDirectory.CONTENT_VIDEO)) {
                        if (lc_fn.endsWith(".vob") || lc_fn.endsWith(".mpeg") || lc_fn.endsWith(".mpg")) {
                            attr = "DLNA.ORG_PN=MPEG_PS_NTSC;DLNA.ORG_OP=01;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000";
                        } else if (lc_fn.endsWith("mkv")) {
                            attr = "DLNA.ORG_PN=MATROSKA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01500000000000000000000000000000";
                        } else if (lc_fn.endsWith("avi")) {
                            attr = "DLNA.ORG_PN=AVI;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01500000000000000000000000000000";
                        } else if (lc_fn.endsWith("wmv")) {
                            attr = "DLNA.ORG_PN=WMVHIGH_FULL;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01500000000000000000000000000000";
                        }
                    } else if (this.item_class.equals("object.item.audioItem.musicTrack")) {
                        if (lc_fn.endsWith(".mp3")) {
                            attr = "DLNA.ORG_PN=MP3;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000";
                        } else if (lc_fn.toLowerCase().endsWith(".wma")) {
                            attr = "DLNA.ORG_PN=WMABASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000";
                        }
                    } else if (this.item_class.equals("object.item.imageItem.photo")) {
                        if (lc_fn.endsWith(".jpg") || lc_fn.endsWith(".jpeg")) {
                            attr = "DLNA.ORG_PN=JPEG_MED;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000";
                        } else if (lc_fn.endsWith(".png")) {
                            attr = "DLNA.ORG_PN=PNG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000";
                        } else if (lc_fn.endsWith(".gif")) {
                            attr = "DLNA.ORG_PN=GIF_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000";
                        }
                    }
                    if (attr != null) {
                        res = String.valueOf(res) + this.getResource(host, client_type, attr);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return res;
        }

        protected String getResource(String host, int client_type, String protocol_info_attributes) {
            String resource = "";
            String[] stringArray = this.content_types;
            int n = this.content_types.length;
            int n2 = 0;
            while (n2 < n) {
                String duration_str;
                String content_type = stringArray[n2];
                LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                attributes.put("protocolInfo", this.getProtocolInfo(content_type, protocol_info_attributes));
                attributes.put("size", String.valueOf(this.getFile().getLength()));
                if (this.item_class.equals(UPnPMediaServerContentDirectory.CONTENT_VIDEO)) {
                    duration_str = this.getDuration(client_type == 2 ? 60000 : -1);
                    if (duration_str != null) {
                        attributes.put("duration", duration_str);
                    }
                    attributes.put("resolution", this.getResolution());
                } else if (this.item_class.equals("object.item.audioItem.musicTrack") && (duration_str = this.getDuration(client_type == 2 ? 60000 : -1)) != null) {
                    attributes.put("duration", duration_str);
                }
                if (client_type == 2) {
                    if (this.item_class.equals(UPnPMediaServerContentDirectory.CONTENT_VIDEO)) {
                        attributes.put("bitrate", "500000");
                    } else if (this.item_class.equals("object.item.audioItem.musicTrack")) {
                        attributes.put("nrAudioChannels", "2");
                        attributes.put("bitrate", "4000");
                        attributes.put("bitsPerSample", "16");
                        attributes.put("sampleFrequency", "44100");
                    } else if (this.item_class.equals("object.item.imageItem.photo")) {
                        attributes.put("resolution", "100x100");
                    }
                }
                resource = String.valueOf(resource) + "<res ";
                Iterator it = attributes.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    resource = String.valueOf(resource) + key + "=\"" + (String)attributes.get(key) + "\"" + (it.hasNext() ? " " : "");
                }
                resource = String.valueOf(resource) + ">" + this.getURI(host, -1) + "</res>";
                ++n2;
            }
            return resource;
        }

        protected String getDIDL(String host, int client_type) {
            String hacked_class = client_type == 2 ? (this.item_class.equals(UPnPMediaServerContentDirectory.CONTENT_VIDEO) ? UPnPMediaServerContentDirectory.XBOX_CONTENT_VIDEO : (this.item_class.equals("object.item.audioItem.musicTrack") ? "object.item.audioItem.musicTrack" : (this.item_class.equals("object.item.imageItem.photo") ? "object.item.imageItem.photo" : this.item_class))) : this.item_class;
            String didle = "<dc:title>" + UPnPMediaServerContentDirectory.this.escapeXML(this.getDisplayTitle()) + "</dc:title>" + "<dc:creator>" + UPnPMediaServerContentDirectory.this.escapeXML(this.getCreator()) + "</dc:creator>";
            String date = this.getDate();
            if (date != null) {
                didle = String.valueOf(didle) + "<dc:date>" + date + "</dc:date>";
            }
            didle = String.valueOf(didle) + "<upnp:class>" + hacked_class + "</upnp:class>" + this.getResources(host, client_type);
            if (client_type == 2 && this.item_class.equals("object.item.audioItem.musicTrack")) {
                didle = String.valueOf(didle) + "<upnp:genre>Unknown</upnp:genre><upnp:artist>Unknown</upnp:artist><upnp:album>Unknown</upnp:album>";
            }
            return didle;
        }

        @Override
        protected String getName() {
            return this.getTitle();
        }

        @Override
        protected String getContentClass() {
            return this.item_class;
        }

        protected String[] getContentTypes() {
            return this.content_types;
        }

        @Override
        protected void deleted(boolean is_link) {
            super.deleted(is_link);
        }

        @Override
        protected long getStorageUsed() {
            return this.getFile().getLength();
        }

        protected String getStringProperty(String name, String def) {
            String result = (String)this.content_file.getProperty(name);
            if (result == null) {
                result = def;
            }
            return result;
        }

        protected long getLongProperty(String name, long def) {
            Long result = (Long)this.content_file.getProperty(name);
            if (result == null) {
                result = def;
            }
            return result;
        }

        @Override
        protected void print(String indent) {
            UPnPMediaServerContentDirectory.this.log(String.valueOf(indent) + this.getTitle() + ", id=" + this.getID() + ", class=" + this.item_class + ", type=" + Arrays.toString(this.content_types));
        }
    }
}

