/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.connect;

import com.aelitis.azureus.plugins.xmwebui.client.connect.XMClientAccount;
import com.aelitis.azureus.plugins.xmwebui.client.connect.XMClientConnectionAdapter;
import com.aelitis.azureus.plugins.xmwebui.client.proxy.XMClientProxy;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientException;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientFactory;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.json.simple.JSONObject;

public class XMClientConnection {
    private static final String CS_DISCONNECTED = "Disconnected";
    private static final String CS_BASIC = "Basic";
    private static final String CS_SECURE_DIRECT = "Secure (Direct)";
    private static final String CS_SECURE_PROXIED = "Secure (Proxied)";
    private static final int CACHE_MILLIS_BASIC = 1000;
    private static final int CACHE_MILLIS_SECURE_DIRECT = 4000;
    private static final int CACHE_MILLIS_SECURE_PROXY = 9000;
    private XMClientAccount account;
    private XMClientConnectionAdapter adapter;
    private XMRPCClient rpc;
    private XMClientProxy proxy;
    private String connection_state = "Disconnected";

    public XMClientConnection(XMClientAccount _ac, XMClientConnectionAdapter _adapter) {
        this.account = _ac;
        this.adapter = _adapter;
    }

    public String getAccessCode() {
        return this.account.getAccessCode();
    }

    public void connect() {
        String ac = this.account.getAccessCode();
        boolean called_connect = false;
        if (ac.contains(".")) {
            int port;
            String host;
            int pos = ac.indexOf(":");
            if (pos == -1) {
                host = ac;
                port = 9091;
            } else {
                host = ac.substring(0, pos);
                port = Integer.parseInt(ac.substring(pos + 1).trim());
            }
            HashMap<String, String> service_map = new HashMap<String, String>();
            service_map.put("protocol", "http");
            service_map.put("ip", host);
            service_map.put("port", String.valueOf(port));
            this.log("Explicit target - " + host + ":" + port);
            this.connect(service_map, false);
            called_connect = true;
        } else {
            try {
                String url = "https://pair.vuze.com/pairing/remote/listBindings?ac=" + this.getAccessCode() + "&jsoncallback=";
                String reply = new String(XMRPCClientUtils.getFromURLBasic(url), "UTF-8");
                reply = reply.substring(1, reply.length() - 1);
                Map json = JSONUtils.decodeJSON(reply);
                Map error = (Map)json.get("error");
                if (error != null) {
                    throw new Exception((String)error.get("msg"));
                }
                List service_list = (List)json.get("result");
                Map target_service = null;
                boolean has_tunnel = false;
                for (Map m : service_list) {
                    String sid = (String)m.get("sid");
                    if (sid.equals("tunnel")) {
                        has_tunnel = true;
                        continue;
                    }
                    if (!sid.equals("xmwebui")) continue;
                    target_service = m;
                }
                if (target_service != null) {
                    this.log("Pairing details obtained for '" + ac + "', supports secure connections=" + has_tunnel);
                    this.connect(target_service, has_tunnel);
                    called_connect = true;
                } else {
                    this.logError("No binding found for Vuze Web Remote, '" + ac + "'");
                }
            }
            catch (Throwable e) {
                this.logError("Pairing details unavailable for '" + ac + "': " + Debug.getNestedExceptionMessage(e));
            }
        }
        if (!called_connect) {
            this.adapter.setConnected(this, false);
        }
    }

    private void connect(Map<String, String> service_map, boolean has_tunnel) {
        block20: {
            String ac = this.account.getAccessCode();
            int cache_millis = 0;
            try {
                boolean http = service_map.get("protocol").equals("http");
                String host = service_map.get("ip");
                int port = Integer.parseInt(service_map.get("port"));
                if (this.account.isBasicEnabled()) {
                    this.log("Attempting direct basic connection");
                    cache_millis = 1000;
                    XMRPCClient rpc_direct = null;
                    try {
                        String user = "vuze";
                        String password = ac;
                        if (!this.account.isBasicDefaults()) {
                            user = this.account.getBasicUser();
                            password = this.account.getBasicPassword();
                        }
                        rpc_direct = XMRPCClientFactory.createDirect(http, host, port, user, password);
                        this.logConnect(CS_BASIC, this.getRPCStatus(rpc_direct));
                        this.rpc = rpc_direct;
                    }
                    catch (Throwable e) {
                        if (rpc_direct != null) {
                            rpc_direct.destroy();
                        }
                        this.logError("    Failed: " + Debug.getNestedExceptionMessage(e));
                    }
                }
                if (this.rpc != null) break block20;
                if (has_tunnel) {
                    String password;
                    String user;
                    XMRPCClient rpc_tunnel;
                    String tunnel_server;
                    if (this.rpc == null && !this.account.isForceProxy()) {
                        tunnel_server = String.valueOf(http ? "http" : "https") + "://" + host + ":" + port + "/";
                        this.log("Attempting direct secured connection: " + tunnel_server);
                        cache_millis = 4000;
                        rpc_tunnel = null;
                        try {
                            user = this.account.getSecureUser();
                            password = this.account.getSecurePassword();
                            rpc_tunnel = XMRPCClientFactory.createTunnel(tunnel_server, ac, user, password);
                            this.logConnect(CS_SECURE_DIRECT, this.getRPCStatus(rpc_tunnel));
                            this.rpc = rpc_tunnel;
                        }
                        catch (Throwable e) {
                            if (rpc_tunnel != null) {
                                rpc_tunnel.destroy();
                            }
                            this.logError("    Failed: " + Debug.getNestedExceptionMessage(e));
                        }
                    }
                    if (this.rpc == null) {
                        tunnel_server = "https://pair.vuze.com/";
                        this.log("Attempting proxy secured connection: " + tunnel_server);
                        cache_millis = 9000;
                        rpc_tunnel = null;
                        try {
                            user = this.account.getSecureUser();
                            password = this.account.getSecurePassword();
                            rpc_tunnel = XMRPCClientFactory.createTunnel(tunnel_server, ac, user, password);
                            this.logConnect(CS_SECURE_PROXIED, this.getRPCStatus(rpc_tunnel));
                            this.rpc = rpc_tunnel;
                        }
                        catch (Throwable e) {
                            if (rpc_tunnel != null) {
                                rpc_tunnel.destroy();
                            }
                            this.logError("    Failed: " + Debug.getNestedExceptionMessage(e));
                        }
                    }
                    break block20;
                }
                this.logError("    Failed - secure connections not enabled in remote Vuze or client is still initialising");
            }
            finally {
                if (this.rpc == null) {
                    this.connection_state = CS_DISCONNECTED;
                    this.adapter.setConnected(this, false);
                } else {
                    if (cache_millis > 0) {
                        this.rpc = XMRPCClientFactory.createCached(this.rpc, cache_millis);
                    }
                    this.adapter.setConnected(this, true);
                }
            }
        }
    }

    public String getConnectionStatus() {
        return this.connection_state;
    }

    private void logConnect(String type, Map args) {
        this.connection_state = type;
        String rem_az_version = (String)args.get("az-version");
        String rem_plug_version = (String)args.get("version");
        this.log("    Connected: Remote Vuze version=" + rem_az_version + ", plugin=" + rem_plug_version);
    }

    public URL getProxyURL() {
        if (this.rpc == null) {
            return null;
        }
        if (this.proxy == null) {
            try {
                this.proxy = new XMClientProxy(this.account.getResourceDir(), this.rpc);
                this.log("Created client proxy on port " + this.proxy.getPort());
            }
            catch (Throwable e) {
                this.logError("Failed to create rpc proxy: " + Debug.getNestedExceptionMessage(e));
                return null;
            }
        }
        try {
            return new URL("http://" + this.proxy.getHostName() + ":" + this.proxy.getPort() + "/");
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public boolean isConnected() {
        return this.rpc != null;
    }

    public JSONObject call(JSONObject request2) throws XMRPCClientException {
        if (this.rpc == null) {
            throw new XMRPCClientException("RPC not connected");
        }
        return this.rpc.call(request2);
    }

    public Map getRPCStatus() throws XMRPCClientException {
        if (this.rpc == null) {
            throw new XMRPCClientException("RPC not connected");
        }
        return this.getRPCStatus(this.rpc);
    }

    private Map getRPCStatus(XMRPCClient rpc) throws XMRPCClientException {
        JSONObject request2 = new JSONObject();
        request2.put("method", "session-get");
        JSONObject reply = rpc.call(request2);
        String result = (String)reply.get("result");
        if (result.equals("success")) {
            Map args = (Map)reply.get("arguments");
            return args;
        }
        throw new XMRPCClientException("RPC call failed: " + result);
    }

    public void destroy() {
        if (this.rpc != null) {
            String ac = this.account.getAccessCode();
            if (this.proxy != null) {
                this.proxy.destroy();
                this.proxy = null;
            }
            this.rpc.destroy();
            this.rpc = null;
            this.log("Disconnected '" + ac + "'");
            this.connection_state = CS_DISCONNECTED;
            this.adapter.setConnected(this, false);
        }
    }

    private void log(String str) {
        this.adapter.log(str);
    }

    private void logError(String str) {
        this.adapter.logError(str);
    }
}

