/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.magneturi.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.HTTPUtils;
import com.aelitis.azureus.core.util.png.PNG;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.bouncycastle.util.encoders.Base64;

public class MagnetURIHandlerImpl
extends MagnetURIHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private static MagnetURIHandlerImpl singleton;
    private static AEMonitor class_mon;
    private static final int DOWNLOAD_TIMEOUT = -1;
    protected static final String NL = "\r\n";
    private static final boolean DEBUG = false;
    private int port;
    private CopyOnWriteList<MagnetURIHandlerListener> listeners = new CopyOnWriteList();
    private Map info_map = new HashMap();
    private Map<String, MagnetURIHandler.ResourceProvider> resources = new HashMap<String, MagnetURIHandler.ResourceProvider>();

    static {
        class_mon = new AEMonitor("MagnetURLHandler:class");
    }

    public static MagnetURIHandler getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new MagnetURIHandlerImpl();
            }
            MagnetURIHandlerImpl magnetURIHandlerImpl = singleton;
            return magnetURIHandlerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected MagnetURIHandlerImpl() {
        ServerSocket socket = null;
        int i = 45100;
        while (i <= 45199) {
            try {
                socket = new ServerSocket(i, 50, InetAddress.getByName("127.0.0.1"));
                this.port = i;
                break;
            }
            catch (Throwable throwable) {
                ++i;
            }
        }
        COConfigurationManager.setIntDefault("magnet.uri.port", this.port);
        COConfigurationManager.registerExportedParameter("magnet.port", "magnet.uri.port");
        if (socket == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "MagnetURI: no free sockets, giving up"));
            }
        } else {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MagnetURI: bound on " + socket.getLocalPort()));
            }
            final ServerSocket f_socket = socket;
            AEThread t = new AEThread("MagnetURIHandler"){

                @Override
                public void runSupport() {
                    int errors = 0;
                    int ok = 0;
                    while (true) {
                        try {
                            while (true) {
                                final Socket sck = f_socket.accept();
                                ++ok;
                                errors = 0;
                                new AEThread2("MagnetURIHandler:processor", true){

                                    @Override
                                    public void run() {
                                        block19: {
                                            boolean close_socket = true;
                                            try {
                                                try {
                                                    String address = sck.getInetAddress().getHostAddress();
                                                    if (address.equals("localhost") || address.equals("127.0.0.1")) {
                                                        BufferedReader br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF8"));
                                                        String line = br.readLine();
                                                        if (line != null) {
                                                            if (line.toUpperCase().startsWith("GET ")) {
                                                                Logger.log(new LogEvent(LOGID, "MagnetURIHandler: processing '" + line + "'"));
                                                                line = line.substring(4);
                                                                int pos = line.lastIndexOf(32);
                                                                line = line.substring(0, pos);
                                                                close_socket = MagnetURIHandlerImpl.this.process(line, br, sck.getOutputStream());
                                                            } else {
                                                                Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + line + "'"));
                                                            }
                                                        } else {
                                                            Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from '" + address + "': no data read"));
                                                        }
                                                        break block19;
                                                    }
                                                    Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from invalid address '" + address + "'"));
                                                }
                                                catch (Throwable e) {
                                                    if (!(e instanceof IOException) && !(e instanceof SocketException)) {
                                                        Debug.printStackTrace(e);
                                                    }
                                                    try {
                                                        if (close_socket) {
                                                            sck.close();
                                                        }
                                                    }
                                                    catch (Throwable throwable) {}
                                                }
                                            }
                                            finally {
                                                try {
                                                    if (close_socket) {
                                                        sck.close();
                                                    }
                                                }
                                                catch (Throwable throwable) {}
                                            }
                                        }
                                    }
                                }.start();
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            if (++errors <= 100) continue;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "MagnetURIHandler: bailing out, too many socket errors"));
                            }
                            return;
                        }
                        break;
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public void process(final String get, final InputStream is, final OutputStream os) throws IOException {
        new AEThread2("MagnetProcessor", true){

            @Override
            public void run() {
                block26: {
                    boolean close = false;
                    try {
                        try {
                            close = MagnetURIHandlerImpl.this.process(get, new BufferedReader(new InputStreamReader(is)), os);
                        }
                        catch (Throwable e) {
                            Debug.out("Magnet processing failed", e);
                            if (close) {
                                try {
                                    is.close();
                                }
                                catch (Throwable e2) {
                                    Debug.out(e2);
                                }
                            }
                            try {
                                os.flush();
                            }
                            catch (Throwable e3) {
                                Debug.out(e3);
                            }
                            if (!close) break block26;
                            try {
                                os.close();
                            }
                            catch (Throwable e4) {
                                Debug.out(e4);
                            }
                        }
                    }
                    finally {
                        if (close) {
                            try {
                                is.close();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        try {
                            os.flush();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        if (close) {
                            try {
                                os.close();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected boolean process(String get, BufferedReader is, OutputStream os) throws IOException {
        original_params = new HashMap<String, String>();
        lc_params = new HashMap<String, String>();
        source_params = new ArrayList<String>();
        pos = get.indexOf(63);
        if (pos == -1) {
            arg_str = "";
        } else {
            arg_str = get.substring(pos + 1);
            if ((pos = arg_str.lastIndexOf(32)) >= 0) {
                arg_str = arg_str.substring(0, pos).trim();
            }
            tok = new StringTokenizer(arg_str, "&");
            while (tok.hasMoreTokens()) {
                arg = tok.nextToken();
                pos = arg.indexOf(61);
                if (pos == -1) {
                    lhs = arg.trim();
                    original_params.put(lhs, "");
                    lc_params.put(lhs.toLowerCase(MessageText.LOCALE_ENGLISH), "");
                    continue;
                }
                try {
                    lhs = arg.substring(0, pos).trim();
                    lc_lhs = lhs.toLowerCase(MessageText.LOCALE_ENGLISH);
                    rhs = UrlUtils.decode(arg.substring(pos + 1).trim());
                    if (lc_lhs.equals("xt")) {
                        if (rhs.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                            original_params.put(lhs, rhs);
                            lc_params.put(lhs, rhs);
                            continue;
                        }
                        existing = (String)lc_params.get("xt");
                        if (existing != null && (existing.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:") || !rhs.startsWith("urn:sha1:"))) continue;
                        original_params.put(lhs, rhs);
                        lc_params.put(lhs, rhs);
                        continue;
                    }
                    original_params.put(lhs, rhs);
                    lc_params.put(lc_lhs, rhs);
                    if (!lc_lhs.equals("xsource")) continue;
                    source_params.add(rhs);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (get.startsWith("/magnet10/badge.img")) {
            for (MagnetURIHandlerListener listener : this.listeners) {
                data /* !! */  = listener.badge();
                if (data /* !! */  == null) continue;
                this.writeReply(os, "image/gif", data /* !! */ );
                return true;
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/magnet10/canHandle.img?")) {
            urn = (String)lc_params.get("xt");
            if (urn != null && urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                data /* !! */  = (byte[])this.listeners.iterator();
                while (data /* !! */ .hasNext()) {
                    listener = (MagnetURIHandlerListener)data /* !! */ .next();
                    data = listener.badge();
                    if (data == null) continue;
                    this.writeReply(os, "image/gif", data);
                    return true;
                }
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/azversion")) {
            this.writeReply(os, "text/plain", "5.7.3.1_CVS");
            return true;
        }
        if (get.startsWith("/magnet10/options.js?") || get.startsWith("/magnet10/default.js?")) {
            resp = "";
            resp = String.valueOf(resp) + this.getJS("magnetOptionsPreamble");
            resp = String.valueOf(resp) + this.getJSS("<a href=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/select/?\"+magnetQueryString+\"\\\" target=\\\"_blank\\\">");
            resp = String.valueOf(resp) + this.getJSS("<img src=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/magnet10/badge.img\\\">");
            resp = String.valueOf(resp) + this.getJSS("Download with Azureus");
            resp = String.valueOf(resp) + this.getJSS("</a>");
            resp = String.valueOf(resp) + this.getJS("magnetOptionsPostamble");
            resp = String.valueOf(resp) + "magnetOptionsPollSuccesses++";
            this.writeReply(os, "application/x-javascript", resp);
            return true;
        }
        if (get.startsWith("/magnet10/pause")) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable resp) {
                // empty catch block
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/select/")) {
            fail_reason = "";
            ok = false;
            urn = (String)lc_params.get("xt");
            if (urn == null) {
                fail_reason = "xt missing";
            } else {
                lc_urn = urn.toLowerCase(MessageText.LOCALE_ENGLISH);
                try {
                    url = lc_urn.startsWith("http:") != false || lc_urn.startsWith("https:") != false ? new URL(urn) : new URL("magnet:?xt=" + urn);
                    for (MagnetURIHandlerListener listener : this.listeners) {
                        if (!listener.download(url)) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        fail_reason = "No listeners accepted the operation";
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    fail_reason = Debug.getNestedExceptionMessage(e);
                }
            }
            if (ok) {
                if ("image".equalsIgnoreCase((String)lc_params.get("result"))) {
                    for (MagnetURIHandlerListener listener : this.listeners) {
                        data = listener.badge();
                        if (data == null) continue;
                        this.writeReply(os, "image/gif", data);
                        return true;
                    }
                }
                this.writeReply(os, "text/plain", "Download initiated");
            } else {
                this.writeReply(os, "text/plain", "Download initiation failed: " + fail_reason);
            }
        } else {
            if (get.startsWith("/download/")) {
                pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                try {
                    pw.print("HTTP/1.0 200 OK\r\n");
                    pw.flush();
                    urn = (String)lc_params.get("xt");
                    if (urn == null || !urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:sha1:") && !urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(MagnetURIHandlerImpl.LOGID, 1, "MagnetURIHandler: invalid command - '" + get + "'"));
                        }
                        throw new IOException("Invalid magnet URI - no urn:sha1 or urn:btih argument supplied.");
                    }
                    encoded = urn.substring(9);
                    sources = new ArrayList<InetSocketAddress>();
                    i = 0;
                    while (i < source_params.size()) {
                        source = (String)source_params.get(i);
                        p = source.indexOf(58);
                        if (p != -1) {
                            try {
                                host = source.substring(0, p);
                                port = Integer.parseInt(source.substring(p + 1));
                                if (host.startsWith("/")) {
                                    host = host.substring(1);
                                }
                                sa = new InetSocketAddress(host, port);
                                sources.add(sa);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        ++i;
                    }
                    s = sources.toArray(new InetSocketAddress[sources.size()]);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(MagnetURIHandlerImpl.LOGID, "MagnetURIHandler: download of '" + encoded + "' starts (initial sources=" + s.length + ")"));
                    }
                    if ((_sha1 = UrlUtils.decodeSHA1Hash(encoded)) == null) {
                        _sha1 = new byte[20];
                    }
                    sha1 = _sha1;
                    data = null;
                    verbose_str = (String)lc_params.get("verbose");
                    verbose = verbose_str != null && verbose_str.equalsIgnoreCase("true") != false;
                    cancel = new boolean[1];
                    keep_alive = SimpleTimer.addPeriodicEvent("MURI:keepalive", 5000L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            pw.print("X-KeepAlive: YEAH!\r\n");
                            boolean failed = pw.checkError();
                            if (!failed) return;
                            boolean[] blArray = cancel;
                            synchronized (cancel) {
                                cancel[0] = true;
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                    try {
                        f_arg_str = arg_str;
                        f_data = new byte[1][];
                        f_error = new Throwable[1];
                        wait_sem = new AESemaphore("download-waiter");
                        tasks = new ArrayList<4>();
                        for (final MagnetURIHandlerListener listener : this.listeners) {
                            tasks.add(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                @Override
                                public void run() {
                                    try {
                                        try {
                                            byte[] data = listener.download(new MagnetURIHandlerProgressListener(){

                                                @Override
                                                public void reportSize(long size) {
                                                    pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("torrent_size", String.valueOf(size)) + MagnetURIHandlerImpl.NL);
                                                    pw.flush();
                                                }

                                                @Override
                                                public void reportActivity(String str) {
                                                    pw.print("X-Report: " + str + MagnetURIHandlerImpl.NL);
                                                    pw.flush();
                                                }

                                                @Override
                                                public void reportCompleteness(int percent) {
                                                    pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("percent", String.valueOf(percent)) + MagnetURIHandlerImpl.NL);
                                                    pw.flush();
                                                }

                                                @Override
                                                public boolean verbose() {
                                                    return verbose;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public boolean cancelled() {
                                                    Object object = cancel;
                                                    synchronized (cancel) {
                                                        block7: {
                                                            if (!cancel[0]) break block7;
                                                            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                                            return true;
                                                        }
                                                        // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                                        object = f_data;
                                                        synchronized (f_data) {
                                                            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                                            return f_data[0] != null;
                                                        }
                                                    }
                                                }
                                            }, sha1, f_arg_str, s, -1L);
                                            byte[][] byArray = f_data;
                                            synchronized (f_data) {
                                                if (data == null) return;
                                                if (f_data[0] != null) return;
                                                f_data[0] = data;
                                                // ** MonitorExit[var2_3] (shouldn't be in output)
                                                return;
                                            }
                                        }
                                        catch (Throwable e) {
                                            byte[][] byArray = f_data;
                                            synchronized (f_data) {
                                                f_error[0] = e;
                                                // ** MonitorExit[var2_4] (shouldn't be in output)
                                                wait_sem.release();
                                                return;
                                            }
                                        }
                                    }
                                    finally {
                                        wait_sem.release();
                                    }
                                }
                            });
                        }
                        if (tasks.size() <= 0) ** break block98
                        if (tasks.size() == 1) {
                            ((Runnable)tasks.get(0)).run();
                        } else {
                            for (final Runnable task : tasks) {
                                new AEThread2("MUH:dasync"){

                                    @Override
                                    public void run() {
                                        task.run();
                                    }
                                }.start();
                            }
                            i = 0;
                            while (i < tasks.size()) {
                                wait_sem.reserve();
                                ++i;
                            }
                        }
                        var26_54 = f_data;
                        synchronized (f_data) {
                            data = f_data[0];
                            if (data == null && f_error[0] != null) {
                                throw f_error[0];
                            }
                            // ** MonitorExit[var26_54] (shouldn't be in output)
                        }
                    }
                    finally {
                        keep_alive.cancel();
                    }
                    {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(MagnetURIHandlerImpl.LOGID, "MagnetURIHandler: download of '" + encoded + "' completes, data " + (data == null ? "not found" : "found, length = " + data.length)));
                        }
                        if (data != null) {
                            pw.print("Content-Length: " + data.length + "\r\n" + "\r\n");
                            pw.flush();
                            os.write(data);
                            os.flush();
                            ** break block99
                        }
                        pw.print("X-Report: error: " + this.getMessageText("no_sources") + "\r\n");
                        pw.flush();
                        return lc_params.containsKey("pause_on_error") == false;
                    }
                }
                catch (Throwable e) {
                    pw.print("X-Report: error: " + this.getMessageText("error", Debug.getNestedExceptionMessage(e)) + "\r\n");
                    pw.flush();
                    return lc_params.containsKey("pause_on_error") == false;
                }
            }
            if (get.startsWith("/getinfo?")) {
                name = (String)lc_params.get("name");
                if (name != null) {
                    info = (Integer)this.info_map.get(name);
                    value = -2147483648;
                    if (info != null) {
                        value = info;
                    } else {
                        for (MagnetURIHandlerListener listener : this.listeners) {
                            paramsCopy = new HashMap<String, String>();
                            paramsCopy.putAll(original_params);
                            value = listener.get(name, paramsCopy);
                            if (value != -2147483648) break;
                        }
                    }
                    if (value == -2147483648) {
                        def_str = (String)lc_params.get("default");
                        if (def_str != null) {
                            try {
                                value = Integer.parseInt(def_str);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    } else {
                        max_str = (String)lc_params.get("max");
                        if (max_str != null) {
                            try {
                                max = Integer.parseInt(max_str);
                                if (value > max) {
                                    value = max;
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    if (value != -2147483648) {
                        if (value < 0) {
                            value = 0;
                        }
                        if (value > 0x100000) {
                            value = 0x100000;
                        }
                        width = value;
                        height = 1;
                        div_mod = (String)lc_params.get("divmod");
                        if (div_mod != null) {
                            n = Integer.parseInt(div_mod);
                            width = value / n + 1;
                            height = value % n + 1;
                        } else {
                            div = (String)lc_params.get("div");
                            if (div != null) {
                                width = value / Integer.parseInt(div);
                            } else {
                                mod = (String)lc_params.get("mod");
                                if (mod != null) {
                                    width = value % Integer.parseInt(mod);
                                }
                            }
                        }
                        img_type = (String)lc_params.get("img_type");
                        if (img_type != null && img_type.equals("png")) {
                            data = PNG.getPNGBytesForSize(width, height);
                            this.writeReply(os, "image/png", data);
                        } else {
                            baos = new ByteArrayOutputStream();
                            this.writeImage(baos, width, height);
                            data = baos.toByteArray();
                            this.writeReply(os, "image/bmp", data);
                        }
                        return true;
                    }
                }
                this.writeNotFound(os);
                return true;
            }
            if (get.startsWith("/setinfo?")) {
                name = (String)lc_params.get("name");
                if (name != null) {
                    result = false;
                    for (MagnetURIHandlerListener listener : this.listeners) {
                        paramsCopy = new HashMap<String, String>();
                        paramsCopy.putAll(original_params);
                        result = listener.set(name, paramsCopy);
                        if (result) break;
                    }
                    width = result != false ? 20 : 10;
                    height = result != false ? 20 : 10;
                    img_type = (String)lc_params.get("img_type");
                    if (img_type != null && img_type.equals("png")) {
                        data = PNG.getPNGBytesForSize(width, height);
                        this.writeReply(os, "image/png", data);
                    } else {
                        baos = new ByteArrayOutputStream();
                        this.writeImage(baos, width, height);
                        data = baos.toByteArray();
                        this.writeReply(os, "image/bmp", data);
                    }
                    return true;
                }
            } else if (get.equals("/browserheaders.js")) {
                headers_str = "";
                while ((header = is.readLine()) != null && (header = header.trim()).length() != 0) {
                    headers_str = String.valueOf(headers_str) + (headers_str.length() == 0 ? "" : "\n") + header;
                }
                script = "var headers = \"" + new String(Base64.encode(headers_str.getBytes("UTF-8"))) + "\";";
                this.writeReply(os, "application/x-javascript", script);
            } else if (get.startsWith("/resource.")) {
                rid = (String)lc_params.get("rid");
                width = this.resources;
                synchronized (width) {
                    provider = this.resources.get(rid);
                }
                if (provider != null) {
                    data /* !! */  = provider.getData();
                    if (data /* !! */  != null) {
                        this.writeReply(os, HTTPUtils.guessContentTypeFromFileType(provider.getFileType()), data /* !! */ );
                    } else {
                        this.writeNotFound(os);
                    }
                } else {
                    this.writeNotFound(os);
                }
            }
        }
lbl-1000:
        // 10 sources

        {
            return true;
        }
    }

    private void writeImage(OutputStream os, int width, int height) {
        int rowWidth = width / 8;
        if (rowWidth % 4 != 0) {
            rowWidth = (rowWidth / 4 + 1) * 4;
        }
        int imageSize = rowWidth * height;
        int fileSize = 54 + imageSize;
        try {
            os.write(new byte[]{66, 77});
            this.write4Bytes(os, fileSize);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 54L);
            this.write4Bytes(os, 40L);
            this.write4Bytes(os, width);
            this.write4Bytes(os, height);
            this.write4Bytes(os, 65537L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, imageSize);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            byte[] data = new byte[imageSize];
            os.write(data);
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    private void write4Bytes(OutputStream os, long l) {
        try {
            os.write((int)(l & 0xFFL));
            os.write((int)(l >> 8 & 0xFFL));
            os.write((int)(l >> 16 & 0xFFL));
            os.write((int)(l >> 24 & 0xFFL));
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    protected String getMessageText(String resource) {
        return MessageText.getString("MagnetURLHandler.report." + resource);
    }

    protected String getMessageText(String resource, String param) {
        if (resource.equals("error")) {
            return param;
        }
        return MessageText.getString("MagnetURLHandler.report." + resource, new String[]{param});
    }

    protected String getJS(String s) {
        return "document.write(" + s + ");" + NL;
    }

    protected String getJSS(String s) {
        return "document.write(\"" + s + "\");" + NL;
    }

    protected void writeReply(OutputStream os, String content_type, String content2) throws IOException {
        this.writeReply(os, content_type, content2.getBytes());
    }

    protected void writeReply(OutputStream os, String content_type, byte[] content2) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.1 200 OK\r\n");
        pw.print("Cache-Control: no-cache\r\n");
        pw.print("Pragma: no-cache\r\n");
        pw.print("Content-Type: " + content_type + NL);
        pw.print("Content-Length: " + content2.length + NL + NL);
        pw.flush();
        os.write(content2);
    }

    protected void writeNotFound(OutputStream os) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.0 404 Not Found\r\n\r\n");
        pw.flush();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void addInfo(String name, int info) {
        this.info_map.put(name, new Integer(info));
        Logger.log(new LogEvent(LOGID, 0, "MagnetURIHandler: global info registered: " + name + " -> " + info));
    }

    @Override
    public void addListener(MagnetURIHandlerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(MagnetURIHandlerListener l) {
        this.listeners.remove(l);
    }

    public static void main(String[] args) {
        new MagnetURIHandlerImpl();
        try {
            Thread.sleep(1000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL registerResource(MagnetURIHandler.ResourceProvider provider2) {
        try {
            String rid = URLEncoder.encode(provider2.getUID(), "UTF-8");
            Map<String, MagnetURIHandler.ResourceProvider> map = this.resources;
            synchronized (map) {
                this.resources.put(rid, provider2);
            }
            return new URL("http://127.0.0.1:" + this.port + "/resource." + provider2.getFileType() + "?rid=" + rid);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }
}

