/*
 * Decompiled with CFR 0.152.
 */
package com.vuze.client.plugins.utp.test;

import com.vuze.client.plugins.utp.UTPProvider;
import com.vuze.client.plugins.utp.UTPProviderCallback;
import com.vuze.client.plugins.utp.UTPProviderException;
import com.vuze.client.plugins.utp.loc.UTPProviderLocal;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class UTPProviderTester
implements UTPProvider {
    private static final boolean TRACE = false;
    private UTPProvider target;
    private static final int MT_CHECK_TIMEOUTS = 1;
    private static final int MT_CONNECT = 2;
    private static final int MT_RECEIVE = 3;
    private static final int MT_WRITE_READY = 4;
    private static final int MT_WRITE_READY2 = 5;
    private static final int MT_RECEIVE_BUFFER_DRAINED = 6;
    private static final int MT_CLOSE = 7;
    private static final int MT_INPUT_IDLE = 8;
    private static final int MT_INCOMING = 9;
    private static final int MT_RANDOM = 10;
    private static final int MT_MICROSECONDS = 11;
    private static final int MT_MILLISECONDS = 12;
    private static final int MT_READ = 13;
    private static final int MT_WRITE = 14;
    private static final int MT_GET_RBS = 15;
    private static final int MT_SEND = 16;
    private static final int MT_SET_STATE = 17;
    private static final int MT_ERROR = 18;
    private static final String[] MT_NAMES = new String[]{"", "check_timeouts", "connect", "receive", "write_ready", "write_ready2", "rec_buff_drain", "close", "input_idle", "incoming", "rand", "micro", "milli", "read", "write", "get_rbs", "send", "set_state", "error"};
    private DataOutputStream recording_stream;
    private DataInputStream playback_stream;
    int in_sequence = 1;
    int out_sequence = 1;
    long TEMP_SOCKET_MAX;
    private long temp_sock_id_next = this.TEMP_SOCKET_MAX = -100000L;
    private Map<Long, Long> playback_socket_map_from_external = new HashMap<Long, Long>();
    private Map<Long, Long> playback_socket_map_to_external = new HashMap<Long, Long>();

    public UTPProviderTester(UTPProvider _target) {
        this(_target, true);
    }

    private UTPProviderTester(UTPProvider _target, boolean _is_recording) {
        this.target = _target;
        String file = "C:\\temp\\utprec.dat";
        if (_is_recording) {
            try {
                this.recording_stream = new DataOutputStream(new FileOutputStream(file));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.playback_stream = new DataInputStream(new FileInputStream(file));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getVersion() {
        return this.target.getVersion();
    }

    private void recordIn(int method, Object ... args) {
        this.record(method, true, args);
    }

    private void recordOut(int method, Object ... args) {
        this.record(method, false, args);
    }

    private void record(int method, boolean in, Object ... args) {
        if (this.recording_stream == null) {
            if (in) {
                String str = "";
                Object[] objectArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + o;
                    ++n2;
                }
            }
            return;
        }
        try {
            try {
                this.recording_stream.writeInt(method);
                this.recording_stream.writeBoolean(in);
                this.recording_stream.writeInt(args.length);
                Object[] objectArray = args;
                int n = args.length;
                int n3 = 0;
                while (n3 < n) {
                    Object o = objectArray[n3];
                    if (o instanceof Integer) {
                        this.recording_stream.writeInt(1);
                        this.recording_stream.writeInt((Integer)o);
                    } else if (o instanceof Long) {
                        this.recording_stream.writeInt(2);
                        this.recording_stream.writeLong((Long)o);
                    } else if (o instanceof Boolean) {
                        this.recording_stream.writeInt(3);
                        this.recording_stream.writeBoolean((Boolean)o);
                    } else if (o instanceof String) {
                        this.recording_stream.writeInt(4);
                        this.recording_stream.writeUTF((String)o);
                    } else if (o instanceof byte[]) {
                        byte[] bytes = (byte[])o;
                        this.recording_stream.writeInt(5);
                        this.recording_stream.writeInt(bytes.length);
                        this.recording_stream.write(bytes);
                    } else {
                        Debug.out("eh?: " + o);
                    }
                    ++n3;
                }
            }
            finally {
                this.recording_stream.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void playbackError(Throwable e) {
        e.printStackTrace();
    }

    private Object[] playbackGetArguments(int num) throws Exception {
        Object[] result = new Object[num];
        int i = 0;
        while (i < num) {
            int type = this.playback_stream.readInt();
            if (type == 1) {
                result[i] = this.playback_stream.readInt();
            } else if (type == 2) {
                result[i] = this.playback_stream.readLong();
            } else if (type == 3) {
                result[i] = this.playback_stream.readBoolean();
            } else if (type == 4) {
                result[i] = this.playback_stream.readUTF();
            } else if (type == 5) {
                int len = this.playback_stream.readInt();
                byte[] bytes = new byte[len];
                this.playback_stream.read(bytes);
                result[i] = bytes;
            } else {
                Debug.out("eh?: " + type);
            }
            ++i;
        }
        return result;
    }

    private void playbackCompareArgs(Object[] actual_args, Object[] expected_args) throws Exception {
        int i = 0;
        while (i < actual_args.length) {
            Object actual_arg = actual_args[i];
            Object expected_arg = expected_args[i];
            if (expected_arg instanceof Integer) {
                int actual;
                int expected = (Integer)expected_arg;
                if (expected != (actual = ((Integer)actual_arg).intValue())) {
                    throw new Exception("int arg mismatch: " + expected + "/" + actual);
                }
            } else if (expected_arg instanceof Long) {
                long actual;
                long expected = (Long)expected_arg;
                if (expected != (actual = ((Long)actual_arg).longValue()) && !this.playbackSocketFixup(actual, expected)) {
                    throw new Exception("long arg mismatch: " + expected + "/" + actual);
                }
            } else if (expected_arg instanceof Boolean) {
                Boolean expected = (Boolean)expected_arg;
                Boolean actual = (Boolean)actual_arg;
                if (expected != actual) {
                    throw new Exception("boolean arg mismatch: " + expected + "/" + actual);
                }
            } else if (expected_arg instanceof String) {
                String expected = (String)expected_arg;
                String actual = (String)actual_arg;
                if (!expected.equals(actual)) {
                    throw new Exception("String arg mismatch: " + expected + "/" + actual);
                }
            } else if (expected_arg instanceof byte[]) {
                byte[] expected = (byte[])expected_arg;
                byte[] actual = (byte[])actual_arg;
                if (!Arrays.equals(expected, actual)) {
                    System.out.println("exp: " + ByteFormatter.encodeString(expected));
                    System.out.println("act: " + ByteFormatter.encodeString(actual));
                    throw new Exception("byte[] arg mismatch: " + expected + "/" + actual);
                }
            } else {
                Debug.out("eh?: " + actual_arg);
            }
            ++i;
        }
    }

    private void playbackIn(int actual_method, Object ... actual_args) {
        int seq;
        if ((seq = this.in_sequence++) == 4763) {
            System.out.println("derp");
        }
        try {
            int expected_method = this.playback_stream.readInt();
            if (expected_method != actual_method) {
                throw new Exception("method mismatch: expected=" + expected_method + ", actual=" + actual_method);
            }
            boolean is_in = this.playback_stream.readBoolean();
            if (!is_in) {
                throw new Exception("expected in");
            }
            int arg_count = this.playback_stream.readInt();
            if (arg_count != actual_args.length) {
                throw new Exception("arg count mismatch");
            }
            Object[] expected_args = this.playbackGetArguments(arg_count);
            this.playbackCompareArgs(actual_args, expected_args);
        }
        catch (Throwable e) {
            this.playbackError(e);
        }
    }

    private Object playbackOut(int expected_method) {
        int arg_count;
        block6: {
            try {
                int method = this.playback_stream.readInt();
                if (method != expected_method) {
                    throw new Exception("method mismatch");
                }
                boolean is_in = this.playback_stream.readBoolean();
                if (is_in) {
                    throw new Exception("expected in");
                }
                arg_count = this.playback_stream.readInt();
                if (arg_count != 0) break block6;
                return null;
            }
            catch (Throwable e) {
                this.playbackError(e);
                return null;
            }
        }
        if (arg_count > 1) {
            throw new Exception("derp");
        }
        return this.playbackGetArguments(arg_count)[0];
    }

    @Override
    public boolean load(UTPProviderCallback callback) {
        return this.target.load(new UTPProviderTesterCallback(callback));
    }

    @Override
    public boolean isValidPacket(byte[] data, int length) {
        return this.target.isValidPacket(data, length);
    }

    @Override
    public void checkTimeouts() {
        this.recordIn(1, new Object[0]);
        this.target.checkTimeouts();
        this.recordOut(1, new Object[0]);
    }

    @Override
    public void incomingIdle() {
        this.recordIn(8, new Object[0]);
        this.target.incomingIdle();
        this.recordOut(8, new Object[0]);
    }

    @Override
    public long[] connect(String to_address, int to_port) throws UTPProviderException {
        this.recordIn(2, to_address, to_port);
        long[] result = this.target.connect(to_address, to_port);
        this.recordOut(2, result[0], result[1]);
        return result;
    }

    @Override
    public boolean receive(String from_address, int from_port, byte[] data, int length) throws UTPProviderException {
        this.recordIn(3, from_address, from_port, data, length);
        boolean result = this.target.receive(from_address, from_port, data, length);
        this.recordOut(3, result);
        return result;
    }

    @Override
    public boolean write(long utp_socket, int avail_bytes) throws UTPProviderException {
        this.recordIn(4, utp_socket, avail_bytes);
        boolean result = this.target.write(utp_socket, avail_bytes);
        this.recordOut(4, result);
        return result;
    }

    @Override
    public boolean write(long utp_socket, ByteBuffer[] buffers, int start, int len) throws UTPProviderException {
        this.recordIn(5, utp_socket, buffers, start, len);
        boolean result = this.target.write(utp_socket, buffers, start, len);
        this.recordOut(5, result);
        return result;
    }

    @Override
    public void receiveBufferDrained(long utp_socket) throws UTPProviderException {
        this.recordIn(6, utp_socket);
        this.target.receiveBufferDrained(utp_socket);
        this.recordOut(6, new Object[0]);
    }

    @Override
    public void close(long utp_socket) throws UTPProviderException {
        this.recordIn(7, utp_socket);
        this.target.close(utp_socket);
        this.recordOut(7, new Object[0]);
    }

    @Override
    public void setSocketOptions(long fd) throws UTPProviderException {
        this.target.setSocketOptions(fd);
    }

    @Override
    public void setOption(int option, int value) {
        this.target.setOption(option, value);
    }

    private long playbackSocketRegisterExternal(long socket) {
        Long mapped = this.playback_socket_map_from_external.get(socket);
        if (mapped != null) {
            return mapped;
        }
        mapped = this.temp_sock_id_next--;
        this.playback_socket_map_from_external.put(socket, mapped);
        this.playback_socket_map_to_external.put(mapped, socket);
        return mapped;
    }

    private long playbackSocketMapFromExternal(long utp_socket) {
        return this.playbackSocketRegisterExternal(utp_socket);
    }

    private void playbackSocketRemoveExternal(long ext) {
        Long internal = this.playback_socket_map_from_external.remove(ext);
        this.playback_socket_map_to_external.remove(internal);
    }

    private long playbackSocketMapToExternal(long utp_socket) throws Exception {
        Long mapped = this.playback_socket_map_to_external.get(utp_socket);
        if (mapped == null) {
            throw new Exception("Failed to map socket to external: " + utp_socket);
        }
        return mapped;
    }

    private boolean playbackSocketFixup(long temp_internal, long real_internal) {
        Long l_external;
        if (temp_internal <= this.TEMP_SOCKET_MAX && (l_external = this.playback_socket_map_to_external.get(temp_internal)) != null) {
            this.playback_socket_map_to_external.put(real_internal, l_external);
            this.playback_socket_map_from_external.put(l_external, real_internal);
            return true;
        }
        return false;
    }

    private void playback() {
        long start = SystemTime.getMonotonousTime();
        try {
            try {
                this.load(new PlaybackCallback());
                while (true) {
                    Object[] args_out;
                    if (this.playback_stream.available() <= 0) {
                        System.out.println("End of input stream");
                        break;
                    }
                    int method = this.playback_stream.readInt();
                    boolean in = this.playback_stream.readBoolean();
                    if (!in) {
                        throw new Exception("call must be 'in': " + method);
                    }
                    int arg_count = this.playback_stream.readInt();
                    Object[] args_in = this.playbackGetArguments(arg_count);
                    switch (method) {
                        case 1: {
                            this.checkTimeouts();
                            args_out = new Object[]{};
                            break;
                        }
                        case 2: {
                            String to_address = (String)args_in[0];
                            int to_port = (Integer)args_in[1];
                            long[] result = this.connect(to_address, to_port);
                            long new_utp_socket = result[0];
                            result[0] = this.playbackSocketRegisterExternal(new_utp_socket);
                            args_out = new Object[]{result[0], result[1]};
                            break;
                        }
                        case 3: {
                            String from_address = (String)args_in[0];
                            int from_port = (Integer)args_in[1];
                            byte[] data = (byte[])args_in[2];
                            int length = (Integer)args_in[3];
                            boolean result = this.receive(from_address, from_port, data, length);
                            args_out = new Object[]{result};
                            break;
                        }
                        case 4: {
                            long utp_socket = (Long)args_in[0];
                            int avail_bytes = (Integer)args_in[1];
                            utp_socket = this.playbackSocketMapToExternal(utp_socket);
                            boolean result = this.write(utp_socket, avail_bytes);
                            args_out = new Object[]{result};
                            break;
                        }
                        case 6: {
                            long utp_socket = (Long)args_in[0];
                            utp_socket = this.playbackSocketMapToExternal(utp_socket);
                            this.receiveBufferDrained(utp_socket);
                            args_out = new Object[]{};
                            break;
                        }
                        case 7: {
                            long utp_socket = (Long)args_in[0];
                            utp_socket = this.playbackSocketMapToExternal(utp_socket);
                            this.close(utp_socket);
                            args_out = new Object[]{};
                            break;
                        }
                        default: {
                            throw new Exception("Unexpected method: " + method);
                        }
                    }
                    int method_ret = this.playback_stream.readInt();
                    if (method_ret != method) {
                        throw new Exception("method ret mismatch: " + method);
                    }
                    boolean in_ret = this.playback_stream.readBoolean();
                    if (in_ret) {
                        throw new Exception("method out mismatch: " + method);
                    }
                    int arg_count_ret = this.playback_stream.readInt();
                    if (arg_count_ret != args_out.length) {
                        throw new Exception("args out mismatch: " + method);
                    }
                    if (arg_count_ret <= 0) continue;
                    Object[] expected_args = this.playbackGetArguments(arg_count_ret);
                    this.playbackCompareArgs(args_out, expected_args);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.out.println("Elapsed=" + (SystemTime.getMonotonousTime() - start));
            }
        }
        finally {
            System.out.println("Elapsed=" + (SystemTime.getMonotonousTime() - start));
        }
    }

    public static void main(String[] args) {
        UTPProviderLocal target_impl = new UTPProviderLocal(true);
        UTPProviderTester tester = new UTPProviderTester(target_impl, false);
        tester.playback();
    }

    private class PlaybackCallback
    implements UTPProviderCallback {
        private PlaybackCallback() {
        }

        @Override
        public File getPluginUserDir() {
            return new File("C:\\test\\utp\\plugins\\azutp");
        }

        @Override
        public File getPluginInstallDir() {
            return new File("C:\\test\\utp\\plugins\\azutp");
        }

        @Override
        public void log(String str, Throwable error) {
            System.out.println(str);
            error.printStackTrace();
        }

        @Override
        public int getRandom() {
            UTPProviderTester.this.playbackIn(10, new Object[0]);
            Integer result = (Integer)UTPProviderTester.this.playbackOut(10);
            return result;
        }

        @Override
        public long getMilliseconds() {
            UTPProviderTester.this.playbackIn(12, new Object[0]);
            Long result = (Long)UTPProviderTester.this.playbackOut(12);
            return result;
        }

        @Override
        public long getMicroseconds() {
            UTPProviderTester.this.playbackIn(11, new Object[0]);
            Long result = (Long)UTPProviderTester.this.playbackOut(11);
            return result;
        }

        @Override
        public void incomingConnection(String address, int port, long utp_socket, long con_id) {
            utp_socket = UTPProviderTester.this.playbackSocketRegisterExternal(utp_socket);
            UTPProviderTester.this.playbackIn(9, new Object[]{address, port, utp_socket, con_id});
            UTPProviderTester.this.playbackOut(9);
        }

        @Override
        public void incomingConnection(InetSocketAddress address, long utp_socket, long con_id) {
            utp_socket = UTPProviderTester.this.playbackSocketRegisterExternal(utp_socket);
            UTPProviderTester.this.playbackIn(9, new Object[]{address.getAddress().getHostAddress(), address.getPort(), utp_socket, con_id});
            UTPProviderTester.this.playbackOut(9);
        }

        @Override
        public boolean send(String address, int port, byte[] buffer, int length) {
            UTPProviderTester.this.playbackIn(16, new Object[]{address, port, buffer, length});
            Boolean result = (Boolean)UTPProviderTester.this.playbackOut(16);
            return result;
        }

        @Override
        public boolean send(InetSocketAddress address, byte[] buffer, int length) {
            UTPProviderTester.this.playbackIn(16, new Object[]{address.getAddress().getHostAddress(), address.getPort(), buffer, length});
            Boolean result = (Boolean)UTPProviderTester.this.playbackOut(16);
            return result;
        }

        @Override
        public void read(long utp_socket, byte[] data) {
            utp_socket = UTPProviderTester.this.playbackSocketMapFromExternal(utp_socket);
            UTPProviderTester.this.playbackIn(13, new Object[]{utp_socket, data});
            UTPProviderTester.this.playbackOut(13);
        }

        @Override
        public void read(long utp_socket, ByteBuffer bb) {
            utp_socket = UTPProviderTester.this.playbackSocketMapFromExternal(utp_socket);
            byte[] data = new byte[bb.remaining()];
            bb.get(data);
            UTPProviderTester.this.playbackIn(13, new Object[]{utp_socket, data});
            UTPProviderTester.this.playbackOut(13);
        }

        @Override
        public void write(long utp_socket, byte[] data, int offset, int length) {
            utp_socket = UTPProviderTester.this.playbackSocketMapFromExternal(utp_socket);
            UTPProviderTester.this.playbackIn(14, new Object[]{utp_socket, offset, length});
            byte[] bytes = (byte[])UTPProviderTester.this.playbackOut(14);
            System.arraycopy(bytes, 0, data, offset, length);
        }

        @Override
        public int getReadBufferSize(long utp_socket) {
            utp_socket = UTPProviderTester.this.playbackSocketMapFromExternal(utp_socket);
            UTPProviderTester.this.playbackIn(15, new Object[]{utp_socket});
            Integer result = (Integer)UTPProviderTester.this.playbackOut(15);
            return result;
        }

        @Override
        public void setState(long external_utp_socket, int state) {
            long utp_socket = UTPProviderTester.this.playbackSocketMapFromExternal(external_utp_socket);
            UTPProviderTester.this.playbackIn(17, new Object[]{utp_socket, state});
            UTPProviderTester.this.playbackOut(17);
            if (state == 4) {
                UTPProviderTester.this.playbackSocketRemoveExternal(external_utp_socket);
            }
        }

        @Override
        public void error(long utp_socket, int error) {
            utp_socket = UTPProviderTester.this.playbackSocketMapFromExternal(utp_socket);
            UTPProviderTester.this.playbackIn(18, new Object[]{utp_socket, error});
            UTPProviderTester.this.playbackOut(18);
        }

        @Override
        public void overhead(long utp_socket, boolean send, int size, int type) {
        }
    }

    private class UTPProviderTesterCallback
    implements UTPProviderCallback {
        private UTPProviderCallback target;

        private UTPProviderTesterCallback(UTPProviderCallback _target) {
            this.target = _target;
        }

        @Override
        public File getPluginUserDir() {
            return this.target.getPluginUserDir();
        }

        @Override
        public File getPluginInstallDir() {
            return this.target.getPluginInstallDir();
        }

        @Override
        public void log(String str, Throwable error) {
            this.target.log(str, error);
        }

        @Override
        public int getRandom() {
            UTPProviderTester.this.recordIn(10, new Object[0]);
            int result = this.target.getRandom();
            UTPProviderTester.this.recordOut(10, new Object[]{result});
            return result;
        }

        @Override
        public long getMilliseconds() {
            UTPProviderTester.this.recordIn(12, new Object[0]);
            long result = this.target.getMilliseconds();
            UTPProviderTester.this.recordOut(12, new Object[]{result});
            return result;
        }

        @Override
        public long getMicroseconds() {
            UTPProviderTester.this.recordIn(11, new Object[0]);
            long result = this.target.getMicroseconds();
            UTPProviderTester.this.recordOut(11, new Object[]{result});
            return result;
        }

        @Override
        public void incomingConnection(String address, int port, long utp_socket, long con_id) {
            UTPProviderTester.this.recordIn(9, new Object[]{address, port, utp_socket, con_id});
            this.target.incomingConnection(address, port, utp_socket, con_id);
            UTPProviderTester.this.recordOut(9, new Object[0]);
        }

        @Override
        public void incomingConnection(InetSocketAddress address, long utp_socket, long con_id) {
            UTPProviderTester.this.recordIn(9, new Object[]{address.getAddress().getHostAddress(), address.getPort(), utp_socket, con_id});
            this.target.incomingConnection(address.getAddress().getHostAddress(), address.getPort(), utp_socket, con_id);
            UTPProviderTester.this.recordOut(9, new Object[0]);
        }

        @Override
        public boolean send(String address, int port, byte[] buffer, int length) {
            UTPProviderTester.this.recordIn(16, new Object[]{address, port, buffer, length});
            boolean result = this.target.send(address, port, buffer, length);
            UTPProviderTester.this.recordOut(16, new Object[]{result});
            return result;
        }

        @Override
        public boolean send(InetSocketAddress address, byte[] buffer, int length) {
            UTPProviderTester.this.recordIn(16, new Object[]{address.getAddress().getHostAddress(), address.getPort(), buffer, length});
            boolean result = this.target.send(address.getAddress().getHostAddress(), address.getPort(), buffer, length);
            UTPProviderTester.this.recordOut(16, new Object[]{result});
            return result;
        }

        @Override
        public void read(long utp_socket, byte[] data) {
            UTPProviderTester.this.recordIn(13, new Object[]{utp_socket, data});
            this.target.read(utp_socket, data);
            UTPProviderTester.this.recordOut(13, new Object[0]);
        }

        @Override
        public void read(long utp_socket, ByteBuffer bb) {
            byte[] data = new byte[bb.remaining()];
            bb.get(data);
            UTPProviderTester.this.recordIn(13, new Object[]{utp_socket, data});
            this.target.read(utp_socket, data);
            UTPProviderTester.this.recordOut(13, new Object[0]);
        }

        @Override
        public void write(long utp_socket, byte[] data, int offset, int length) {
            UTPProviderTester.this.recordIn(14, new Object[]{utp_socket, length});
            this.target.write(utp_socket, data, offset, length);
            UTPProviderTester.this.recordOut(14, new Object[]{data});
        }

        @Override
        public int getReadBufferSize(long utp_socket) {
            UTPProviderTester.this.recordIn(15, new Object[]{utp_socket});
            int result = this.target.getReadBufferSize(utp_socket);
            UTPProviderTester.this.recordOut(15, new Object[]{result});
            return result;
        }

        @Override
        public void setState(long utp_socket, int state) {
            UTPProviderTester.this.recordIn(17, new Object[]{utp_socket, state});
            this.target.setState(utp_socket, state);
            UTPProviderTester.this.recordOut(17, new Object[0]);
        }

        @Override
        public void error(long utp_socket, int error) {
            UTPProviderTester.this.recordIn(18, new Object[]{utp_socket, error});
            this.target.error(utp_socket, error);
            UTPProviderTester.this.recordOut(18, new Object[0]);
        }

        @Override
        public void overhead(long utp_socket, boolean send, int size, int type) {
            this.target.overhead(utp_socket, send, size, type);
        }
    }
}

