/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.azureus;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import lbms.plugins.mldht.azureus.DHTPeer;
import lbms.plugins.mldht.kad.PeerAddressDBItem;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;

public class DHTAnnounceResult
implements DownloadAnnounceResult {
    private Download dl;
    private Collection<PeerAddressDBItem> peers;
    private DownloadAnnounceResultPeer[] resultPeers;
    int delay;
    int scrapeSeeds;
    int scrapePeers;

    public DHTAnnounceResult(Download dl, Collection<PeerAddressDBItem> peers, int delay) {
        this.dl = dl;
        this.peers = peers;
        this.delay = delay;
    }

    private void convertPeers() {
        this.resultPeers = new DownloadAnnounceResultPeer[this.peers.size()];
        int i = 0;
        for (PeerAddressDBItem it : this.peers) {
            this.resultPeers[i++] = new DHTPeer(it);
        }
    }

    public void setScrapeSeeds(int scrapeSeeds) {
        this.scrapeSeeds = scrapeSeeds;
    }

    public void setScrapePeers(int scrapePeers) {
        this.scrapePeers = scrapePeers;
    }

    @Override
    public Download getDownload() {
        return this.dl;
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    public Map getExtensions() {
        return null;
    }

    @Override
    public int getNonSeedCount() {
        return this.scrapePeers;
    }

    @Override
    public DownloadAnnounceResultPeer[] getPeers() {
        if (this.resultPeers == null) {
            this.convertPeers();
        }
        return this.resultPeers;
    }

    @Override
    public int getReportedPeerCount() {
        return 0;
    }

    @Override
    public int getResponseType() {
        return 1;
    }

    @Override
    public int getSeedCount() {
        return this.scrapeSeeds;
    }

    @Override
    public long getTimeToWait() {
        return this.delay;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("dht", "mldht", "announce");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

