/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.messages;

import java.util.Map;
import java.util.TreeMap;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.messages.MessageBase;

public class FindNodeResponse
extends MessageBase {
    protected byte[] nodes;
    protected byte[] nodes6;

    public FindNodeResponse(byte[] mtid, byte[] nodes, byte[] nodes6) {
        super(mtid, MessageBase.Method.FIND_NODE, MessageBase.Type.RSP_MSG);
        this.nodes = nodes;
        this.nodes6 = nodes6;
    }

    @Override
    public void apply(DHT dh_table) {
        dh_table.response(this);
    }

    @Override
    public Map<String, Object> getInnerMap() {
        TreeMap<String, Object> inner = new TreeMap<String, Object>();
        inner.put("id", this.id.getHash());
        if (this.nodes != null) {
            inner.put("nodes", this.nodes);
        }
        if (this.nodes6 != null) {
            inner.put("nodes6", this.nodes6);
        }
        return inner;
    }

    public byte[] getNodes(DHT.DHTtype type) {
        if (type == DHT.DHTtype.IPV4_DHT) {
            return this.nodes;
        }
        if (type == DHT.DHTtype.IPV6_DHT) {
            return this.nodes6;
        }
        return null;
    }

    public byte[] getNodes() {
        return this.nodes;
    }

    public byte[] getNodes6() {
        return this.nodes6;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + (this.nodes != null ? "contains: " + this.nodes.length / DHT.DHTtype.IPV4_DHT.NODES_ENTRY_LENGTH + " nodes" : "") + (this.nodes6 != null ? "contains: " + this.nodes6.length / DHT.DHTtype.IPV6_DHT.NODES_ENTRY_LENGTH + " nodes6" : "");
    }
}

